/***
*spawnl.c - spawn a child process
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines spawnl() - spawn a child process
*
*******************************************************************************/

#include <assert.h>
#include <stdlib.h>
#include <process.h>


/***
*int _spawnl(modeflag, pathname, arglist) - spawn a child process
*
*Purpose:
*   Spawns a child process.
*   formats the parameters and calls spawnve to do the actual work. The
*   new process will inherit the parent's environment. NOTE - at least
*   one argument must be present.  This argument is always, by convention,
*   the name of the file being spawned.
*
*Entry:
*   int modeflag   - defines which mode of spawn (WAIT, NOWAIT, or OVERLAY)
*            only WAIT and OVERLAY are currently implemented
*   char *pathname - file to be spawned
*   char *arglist  - list of argument
*   call as spawnl(modeflag, path, arg0, arg1, ..., argn, NULL);
*
*Exit:
*   returns exit code of child process
*   returns -1 if fails
*
*Exceptions:
*
*******************************************************************************/

int  _spawnl (
    int modeflag, const char * pathname, const char * arglist, ...)
{
    assert(pathname != NULL);
    assert(*pathname != '\0');
    assert(arglist != NULL);
    assert(*arglist != '\0');

    return(_spawnve(modeflag,pathname,&arglist,_environ));
}
