/***
*spawnle.c - spawn a child process with given environment
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines spawnle() - spawn a child process with given environ
*
*******************************************************************************/

#include <register.h>
#include <assert.h>
#include <stddef.h>
#include <process.h>


/***
*int _spawnle(modeflag, pathname, arglist) - spawn a child process with env.
*
*Purpose:
*   Spawns a child process with given parameters and environment.
*   formats the parameters and calls spawnve to do the actual work.
*   NOTE - at least one argument must be present.  This argument is always,
*   by convention, the name of the file being spawned.
*
*Entry:
*   int modeflag   - mode of spawn (WAIT, NOWAIT, OVERLAY)
*            only WAIT, and OVERLAY currently implemented
*   char *pathname - name of file to spawn
*   char *arglist  - argument list, environment is at the end
*   call as spawnle(modeflag, path, arg0, arg1, ..., argn, NULL, envp);
*
*Exit:
*   returns exit code of spawned process
*   if fails, return -1
*
*Exceptions:
*
*******************************************************************************/

int  _spawnle(
    int modeflag, const char * pathname, const char * arglist, ...)
{
    REG1 const char **argp;

    assert(pathname != NULL);
    assert(*pathname != '\0');
    assert(arglist != NULL);
    assert(*arglist != '\0');

    /* walk the arglist until the terminating NULL pointer is found.  The
     * next location holds the environment table pointer.
     */

    argp = &arglist;
    while (*argp++)
        ;

    return(_spawnve(modeflag,pathname,&arglist,(char **)*argp));
}
