/***
*spawnlp.c - spawn a file; search along PATH
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines spawnlp() - spawn a file with search along PATH
*
*******************************************************************************/

#include <assert.h>
#include <stddef.h>
#include <process.h>


/***
*_spawnlp(modeflag, filename, arglist) - spawn file and search along PATH
*
*Purpose:
*   Spawns a child process.
*   formats the parameters and calls spawnvp to do the work of searching
*   the PATH environment variable and calling spawnve.  The NULL
*   environment pointer indicates that the new process will inherit the
*   parents process's environment.  NOTE - at least one argument must be
*   present.  This argument is always, by convention, the name of the file
*   being spawned.
*
*Entry:
*   int modeflag   - mode of spawn (WAIT, NOWAIT, OVERLAY)
*            only WAIT, OVERLAY currently implemented
*   char *pathname - file to spawn
*   char *arglist  - argument list
*   call as spawnlp(modeflag, path, arg0, arg1, ..., argn, NULL);
*
*Exit:
*   returns exit code of child process
*   returns -1 if fails
*
*Exceptions:
*
*******************************************************************************/

int  _spawnlp(
    int modeflag, const char * filename, const char * arglist, ...)
{

    assert(filename != NULL);
    assert(*filename != '\0');
    assert(arglist != NULL);
    assert(*arglist != '\0');

    return(_spawnvp(modeflag,filename,&arglist));
}
