/***
*spawnlpe.c - spawn a child process with environ and search along PATH
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines spawnlpe() - spawn a child process with environ/PATH search
*
*******************************************************************************/

#include <register.h>
#include <assert.h>
#include <stddef.h>
#include <process.h>


/***
*int _spawnlpe(modeflag, filename, arglist) - spawn a child process
*
*Purpose:
*   Spawns a child process.
*   formats the parameters and calls spawnvpe to do the work of searching
*   the PATH environment variable and calling spawnve.  The NULL
*   environment pointer indicates that the new process will inherit the
*   parents process's environment.  NOTE - at least one argument must be
*   present.  This argument is always, by convention, the name of the file
*   being spawned.
*
*Entry:
*   int modeflag   - defines what mode of spawn (WAIT, NOWAIT, OVERLAY)
*            only WAIT and OVERLAY currently supported
*   char *pathname - file to spawn
*   char *arglist  - list of arguments (environ at end)
*   call as spawnlpe(modeflag, path, arg0, arg1, ..., argn, NULL, envp);
*
*Exit:
*   returns exit code of spawned process
*   returns -1 if fails
*
*Exceptions:
*
*******************************************************************************/

int  _spawnlpe(
    int modeflag, const char * filename, const char * arglist, ...)
{
    REG1 const char **argp;

    assert(filename != NULL);
    assert(*filename != '\0');
    assert(arglist != NULL);
    assert(*arglist != '\0');
    argp = &arglist;
    while (*argp++)
        ;

    return(_spawnvpe(modeflag,filename,&arglist,(char **)*argp));
}
