/***
*spawnv.c - spawn a child process
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines spawnv() - spawn a child process
*
*******************************************************************************/

#include <assert.h>
#include <stdlib.h>
#include <process.h>


/***
*int _spawnv(modeflag, pathname, argv) - spawn a child process
*
*Purpose:
*   Spawns a child process.
*   formats the parameters and calls spawnve to do the actual work.  The
*   NULL environment pointer indicates the new process will inherit the
*   parents process's environment.  NOTE - at least one argument must be
*   present.  This argument is always, by convention, the name of the file
*   being spawned.
*
*Entry:
*   int modeflag   - mode to spawn (WAIT, NOWAIT, or OVERLAY)
*            only WAIT and OVERLAY currently implemented
*   char *pathname - file to spawn
*   char **argv    - vector of arguments
*
*Exit:
*   returns exit code of child process
*   if fails, returns -1
*
*Exceptions:
*
*******************************************************************************/

int  _spawnv (modeflag, pathname, argv)
int modeflag;
const char *pathname;
const char * const *argv;
{
    assert(pathname != NULL);
    assert(*pathname != '\0');
    assert(argv != NULL);
    assert(*argv != NULL);
    assert(**argv != '\0');

    return(_spawnve(modeflag,pathname,argv,_environ));
}
