/***
*spawnvp.c - spawn a child process; search along PATH
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines spawnvp() - spawn a child process; search along PATH
*
*******************************************************************************/

#include <register.h>
#include <stdlib.h>
#include <process.h>

/***
*int _spawnvp(modeflag, filename, argv) - spawn a child process (search PATH)
*
*Purpose:
*   Spawns a child process, with search along PATH variable.
*   formats the parameters and calls spawnve to do the actual work. The
*   NULL environment pointer indicates the new process will inherit the
*   parents process's environment.  NOTE - at least one argument must be
*   present.  This argument is always, by convention, the name of the file
*   being spawned.
*
*Entry:
*   int modeflag - mode to spawn (WAIT, NOWAIT, or OVERLAY)
*           only WAIT and OVERLAY currently supported
*   char *pathname - name of file to spawn
*   char **argv - vector of arguments
*
*Exit:
*   returns exit code of child process
*   returns -1 if fails
*
*Exceptions:
*
*******************************************************************************/

int  _spawnvp(modeflag, filename, argv)
int modeflag;
const REG3 char *filename;
const char * const *argv;
{
    return _spawnvpe(modeflag, filename, argv, _environ);
}
