/***
*system.c - pass a command line to the shell
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines system() - passes a command to the shell
*
*******************************************************************************/

#include <assert.h>
#include <process.h>
#include <io.h>
#include <stdlib.h>
#include <errno.h>

/***
*int system(command) - send the command line to a shell
*
*Purpose:
*   Executes a shell and passes the command line to it.
*   If command is NULL, determine if a command processor exists.
*
*Entry:
*   char *command - command to pass to the shell (if NULL, just determine
*           if command processor exists)
*
*Exit:
*   if command != NULL  returns status of the shell
*   if command == NULL  returns non-zero if CP exists, zero if CP doesn't exist
*
*Exceptions:
*
*******************************************************************************/

int  system (command)
const char *command;
{
    int catch;
    char *argv[4];

    argv[0] = getenv("COMSPEC");

    if (command == NULL) {
    return (!_access(argv[0],0));
    }
    assert(*command != '\0');

    argv[1] = "/c";
    argv[2] = (char *) command;
    argv[3] = NULL;

    /* If there is a COMSPEC defined, try spawning the shell */

    if (argv[0])    /* Do not try to spawn the null string */
    if ((catch = _spawnve(_P_WAIT,argv[0],argv,_environ)) != -1
        || (errno != ENOENT && errno != EACCES))
        return(catch);

    argv[0] = "command.com";

    /* Let the spawnvpe routine do the path search and spawn. */

    return(_spawnvpe(_P_WAIT,argv[0],argv,_environ));
}
