/***
*doscalls.h - functions declarations for OS/2 function calls
*
*   Copyright (c) 1986-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Function declarations to provide strong type checking on
*   arguments to OS/2 function calls used by the C run-time.
*   Only those functions which are referenced in C sources
*   are included in this file.  This saves compilation time,
*   reduces the amount of memory needed by the compiler, and
*   prevents recompilation due to changes that do not directly
*   affect the  C run-time.  This file should be updated when a
*   "C" module is changed to use a new OS/2 function call.
*   [Internal]
*
****/


/* fsDateFmt */

#define DATEFMT_MM_DD_YY  0x0000
#define DATEFMT_DD_MM_YY  0x0001
#define DATEFMT_YY_MM_DD  0x0002

/* fsCurrencyFmt */

#define CURRENCY_FOLLOW   0x0001
#define CURRENCY_SPACE    0x0002
#define CURRENCY_DECIMAL  0x0004

typedef struct _COUNTRYCODE {
    unsigned short  country;
    unsigned short  codepage;
} COUNTRYCODE;
typedef COUNTRYCODE far *PCOUNTRYCODE;


typedef struct _COUNTRYINFO {
    unsigned short  country;
    unsigned short  codepage;
    unsigned short  fsDateFmt;
    char    szCurrency[5];
    char    szThousandsSeparator[2];
    char    szDecimal[2];
    char    szDateSeparator[2];
    char    szTimeSeparator[2];
    unsigned char   fsCurrencyFmt;
    unsigned char   cDecimalPlace;
    unsigned char   fsTimeFmt;
    unsigned short  abReserved1[2];
    char    szDataSeparator[2];
    unsigned short  abReserved2[5];
} COUNTRYINFO;
typedef COUNTRYINFO far *PCOUNTRYINFO;


struct DateTime {
    unsigned char hour;     /* current hour */
    unsigned char minutes;      /* current minute */
    unsigned char seconds;      /* current second */
    unsigned char hundredths;   /* current hundredths of a second */
    unsigned char day;      /* current day */
    unsigned char month;        /* current month */
    unsigned year;          /* current year */
    int timezone;           /* minutes of time west of GMT */
    unsigned char day_of_week;  /* current day of week */
    };


struct FileFindBuf {
    unsigned create_date;       /* date of file creation */
    unsigned create_time;       /* time of file creation */
    unsigned access_date;       /* date of last access */
    unsigned access_time;       /* time of last access */
    unsigned write_date;        /* date of last write */
    unsigned write_time;        /* time of last write */
    unsigned long file_size;    /* file size (end of data) */
    unsigned long falloc_size;  /* file allocated size */
    unsigned attributes;        /* attributes of the file */
    unsigned char string_len;   /* returned length of ascii name str. */
                    /* length does not include null byte */
    char file_name[257];        /* name string */
    };


struct FileStatus {
    unsigned create_date;       /* date of file creation */
    unsigned create_time;       /* time of file creation */
    unsigned access_date;       /* date of last access */
    unsigned access_time;       /* time of last access */
    unsigned write_date;        /* date of last write */
    unsigned write_time;        /* time of last write */
    unsigned long file_size;    /* file size (end of data) */
    unsigned long falloc_size;  /* file allocated size */
    unsigned attributes;        /* attributes of the file */
    };


#ifdef __cplusplus
extern "C" {
#endif

/* DosBufReset - Flush File Buffers */

extern unsigned short far pascal DOSBUFRESET (
    unsigned short );           /* file handle to flush */

/* DosFindClose - Close Find Handle */

extern unsigned far pascal DOSFINDCLOSE (
    unsigned );     /* Directory search handle */


/* DosFindFirst - Find First Matching File */

extern unsigned far pascal DOSFINDFIRST (
    char far *,     /* File path name */
    unsigned far *,     /* Directory search handle */
    unsigned,       /* Search attribute */
    struct FileFindBuf far *, /* Result buffer */
    unsigned,       /* Result buffer length */
    unsigned far *,     /* Number of entries to find */
    unsigned long );    /* Reserved (must be 0) */


/* DosGetDateTime - Get the current date and time */

extern unsigned far pascal DOSGETDATETIME (
    struct DateTime far * );


/* DosNewSize - Change File's Size */

extern unsigned far pascal DOSNEWSIZE (
    unsigned,       /* File handle */
    unsigned long );    /* File's new size */


/* DosQCurDir - Query Current Directory */

extern unsigned far pascal DOSQCURDIR (
    unsigned,       /* Drive number - 1=A, etc */
    char far *,     /* Directory path buffer */
    unsigned far * );   /* Directory path buffer length */


/* DosQCurDisk - Query Current Disk */

extern unsigned far pascal DOSQCURDISK (
    unsigned far *,     /* Default drive number */
    unsigned long far * );  /* Drive-map area */


/* DosQFileInfo - Query a File's Information */

extern unsigned far pascal DOSQFILEINFO (
    unsigned,       /* File handle */
    unsigned,       /* File data required */
    char far *,     /* File data buffer */
    unsigned );     /* File data buffer size */


/* DosQHandType - Query Handle type */

extern unsigned far pascal DOSQHANDTYPE (
    unsigned,       /* File Handle */
    unsigned far *,     /* HandleType(0=file,1=device,2=pipe)*/
    unsigned far * );   /* Device Driver Attribute Word */


/* DosSetFileInfo - Set a File's Information */

extern unsigned far pascal DOSSETFILEINFO (
    unsigned,       /* File handle */
    unsigned,       /* File info data required */
    char far *,     /* File info buffer */
    unsigned );     /* File info buffer size */

/* DosClose - Close a specified file or pipe */

extern unsigned far pascal DOSCLOSE (
    unsigned );     /* File handle */

/* DosDupHandle - duplicate a file handle */

extern unsigned far pascal DOSDUPHANDLE (
    unsigned,       /* Old file handle */
    unsigned far * );   /* Pointer to new file handle */

/* DosQFHandState - query the state of a file handle */

extern unsigned far pascal DOSQFHANDSTATE (
    unsigned,       /* File handle */
    unsigned far * );   /* Pointer to returned file handle state */

/* DosSetFHandState - modify a file handle's flags */

extern unsigned far pascal DOSSETFHANDSTATE (
    unsigned,       /* File handle */
    unsigned );     /* New file state flags */


/* International Support */

extern unsigned far pascal DOSGETCTRYINFO (
    unsigned short,
    PCOUNTRYCODE,
    PCOUNTRYINFO,
    unsigned short far * );

extern unsigned far pascal DOSGETDBCSEV (
    unsigned short,
    PCOUNTRYCODE,
    unsigned char far * );

extern unsigned far pascal DOSCASEMAP (
    unsigned short,
    PCOUNTRYCODE,
    unsigned char far * );

extern unsigned far pascal DOSGETCOLLATE (
    unsigned short,
    PCOUNTRYCODE,
    unsigned char far *,
    unsigned short far * );

extern unsigned far pascal DOSGETCP (
    unsigned short,
    unsigned short far *,
    unsigned short far * );

extern unsigned far pascal DOSSETCP (
    unsigned short,
    unsigned short );

extern unsigned far pascal DOSSETPROCCP (
    unsigned short,
    unsigned short );


#ifdef __cplusplus
}
#endif
