/***
*fltintrn.h - contains declarations of internal floating point types,
*         routines and variables
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Declares floating point types, routines and variables used
*   interanlly by the C run-time.
*   [Internal]
*
****/

#ifndef _INC_FLTINTRN


#ifdef __cplusplus
extern "C" {
#endif

#if (_MSC_VER <= 600)
#define __far       _far
#define __near      _near
#endif

/*
 * struct used to fool the compiler into not generating floating point
 * instructions when copying and pushing double values
 */

#ifndef DOUBLE

typedef struct {
    double x;
} DOUBLE;

#endif

/*
 *  typedef for _fltout
 */


typedef struct _strflt
{
    int sign;         /* zero if positive otherwise negative */
    int decpt;        /* exponent of floating point number */
    int flag;         /* zero if okay otherwise IEEE overflow */
    char *mantissa;       /* pointer to mantissa in string form */
}
    *STRFLT;


/*
 * typedef for _fltin
 */

typedef struct _flt
{
    int flags;
    int nbytes;      /* number of characters read */
    long lval;
    DOUBLE dval;         /* the returned floating point number */
}
    *FLT;


/* floating point conversion routines, keep in sync with mrt7\include\convert.h */

#ifndef _WINDOWS
char *_cftoe(double *, char *, int, int);
char *_cftof(double *, char *, int);
void _fptostr(char *, int, STRFLT);
#else
char __far *_cftoe(double __far *, char __far *, int, int);
char __far *_cftof(double __far *, char __far *, int);
void _fptostr(char __far *, int, STRFLT);
#endif          /* ... ifndef _WINDOWS */

#ifdef  _MT

STRFLT  _fltout2( DOUBLE, struct _strflt near *, char near * );
FLT _fltin2( struct _flt near * , const char *, int, int, int );

#else

STRFLT  _fltout( DOUBLE );
FLT _fltin( const char *, int, int, int );

#endif

/*
 * table of pointers to floating point helper routines
 *
 * We can't specify the prototypes for the entries of the table accurately,
 * since different functions in the table have different arglists.
 * So we declare the functions to take and return void (which is the
 * correct prototype for _fptrap(), which is what the entries are all
 * initialized to if no floating point is loaded) and cast appropriately
 * on every usage.
 */

typedef void (* PFV)(void);
#ifdef  _WINDOWS
 extern PFV __near _cfltcvt_tab[6];
#else
 extern PFV _cfltcvt_tab[6];
#endif

#ifndef _WINDLL
typedef void (* PF0)(double*, char*, int, int, int);
#else
typedef void (* PF0)(double __far *, char __far *, int, int, int);
#endif
#define _cfltcvt(a,b,c,d,e) (*((PF0)_cfltcvt_tab[0]))(a,b,c,d,e)

typedef void (* PF2)(int, char __far *, char*);
#define _fassign(a,b,c)     (*((PF2)_cfltcvt_tab[1]))(a,b,c)

#ifndef _WINDLL
typedef void (* PF1)(char*);
#else
typedef void (* PF1)(char __far *);
#endif
#define _cropzeros(a)       (*((PF1)_cfltcvt_tab[2]))(a)

#ifndef _WINDLL
typedef void (* PF3)(char*);
#else
typedef void (* PF3)(char __far *);
#endif
#define _forcdecpt(a)       (*((PF3)_cfltcvt_tab[3]))(a)

typedef int  (* PF4)(double*);
#define _positive(a)        (*((PF4)_cfltcvt_tab[4]))(a)

#ifndef _WINDLL
typedef void (* PF5)(long double*, char*, int, int, int);
#else
typedef void (* PF5)(long double __far *, char __far *, int, int, int);
#endif
#define _cldcvt(a,b,c,d,e)  (*((PF5)_cfltcvt_tab[5]))(a,b,c,d,e)

typedef void (* PF2)(int, char __far *, char*);
#define _ldfassign(a,b,c)     (*((PF2)_cfltcvt_tab[6]))(a,b,c)


#ifdef __cplusplus
}
#endif

#define _INC_FLTINTRN
#endif  /* _INC_FLTINTRN */
