/***
*hilo.h - hi and lo word macros
*
*   Copyright (c) 1987-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   This file defines the hi word/lo word macros for big/little
*   endian and long data.
*
****/


#ifdef  M_I86LE  /* Little Endian (low word at low addr) */
#define  LOWORD(data)  ((unsigned int)data)
#define  HIWORD(data)  ((unsigned int)(data>>16))
#endif  M_I86LE

#ifdef  M_I86BE  /* Big Endian (hi word at low addr) */
#define  LOWORD(data)  ((unsigned int)(data>>16))
#define  HIWORD(data)  ((unsigned int)data)
#endif  M_I86BE
