/***
*jctype.h - kanji character conversion macros and jctype macros
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Defines macros for kanji character classification/conversion.
*
*******************************************************************************/

/*
*   Define _MBCS and _KANJI, as a Kanji build requires both of these
*   parameters.
*/

#define _MBCS   1
#define _KANJI  1

#include <mbctype.h>

#ifdef __cplusplus
extern "C" {
#endif

#if (_MSC_VER <= 600)
#define __cdecl     _cdecl
#define __far       _far
#define __near      _near
#endif

/*
 * Define the jctype lookup array.
 */

extern unsigned char __near __cdecl _mbctype[];
extern unsigned char __near __cdecl _ctype[];

/* Kanji character classification function prototypes */
#ifndef _JCTYPE_DEFINED
#define iskana      _ismbbkana
#define iskpun      _ismbbkpunct
#define iskmoji     _ismbbkalpha
#define isalkana    _ismbbalpha
#define ispnkana    _ismbbpunct
#define isalnmkana  _ismbbalnum
#define isprkana    _ismbbprint
#define isgrkana    _ismbbgraph
#define iskanji     _ismbblead
#define iskanji2    _ismbbtrail
#define _JCTYPE_DEFINED

#else

/* the kanji character classification macro definitions */

#define iskana(_c)  ((_mbctype+1)[(unsigned char)(_c)] & (_MS|_MP))
#define iskpun(_c)  ((_mbctype+1)[(unsigned char)(_c)] & _MP)
#define iskmoji(_c) ((_mbctype+1)[(unsigned char)(_c)] & _MS)
#define isalkana(_c)    (((_ctype+1)[(unsigned char)(_c)] & (_UPPER|_LOWER))||iskmoji(_c))
#define ispnkana(_c)    (((_ctype+1)[(unsigned char)(_c)] & _PUNCT)||iskpun(_c))
#define isalnmkana(_c)  (((_ctype+1)[(unsigned char)(_c)] & (_UPPER|_LOWER|_DIGIT))||iskmoji(_c))
#define isprkana(_c)    (((_ctype+1)[(unsigned char)(_c)] & (_BLANK|_PUNCT|_UPPER|_LOWER|_DIGIT))||iskana(_c))
#define isgrkana(_c)    (((_ctype+1)[(unsigned char)(_c)] & (_PUNCT|_UPPER|_LOWER|_DIGIT))||iskana(_c))

#define iskanji(_c) ((_mbctype+1)[(unsigned char)(_c)] & _M1)
#define iskanji2(_c)    ((_mbctype+1)[(unsigned char)(_c)] & _M2)

#endif

#ifdef __cplusplus
}
#endif
