/***
*jstring.h - declarations for kanji string manipulation functions
*
*   Copyright (C) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   This file contains the function declarations for the kanji string
*   manipulation functions.
*
*******************************************************************************/

#define _MBCS   1
#define _KANJI  1

#include <mbstring.h>

#ifdef __cplusplus
extern "C" {
#endif

#if (_MSC_VER <= 600)
#define __cdecl     _cdecl
#define __far       _far
#endif


#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif


/* byte types  */

#define CT_ANK  0
#define CT_KJ1  1
#define CT_KJ2  2
#define CT_ILGL -1


/* C 6.0 names supplied for upward compatibility */

#define btom        _mbsnccnt
#define chkctype    _mbbtype
#define jstradv     _mbsninc
#define jstrchr     _mbschr
#define jstrcmp     _mbscmp
#define jstrcspn    _mbscspn
#define jstricmp    _mbsicmp
#define jstrlen     _mbslen
#define jstrlwr     _mbslwr
#define jstrmatch   _mbspbrk
#define jstrncat    _mbsncat
#define jstrncmp    _mbsncmp
#define jstrncpy    _mbsncpy
#define jstrnicmp   _mbsnicmp
#define jstrnset    _mbsnset
#define jstrrchr    _mbsrchr
#define jstrrev     _mbsrev
#define jstrset     _mbsset
#define jstrskip    _mbsspnp
#define jstrspn     _mbsspn
#define jstrstr     _mbsstr
#define jstrtok     _mbstok
#define jstrupr     _mbsupr
#define mtob        _mbsnbcnt
#define nthctype    _mbsbtype

#define jisalpha    _ismbcalpha
#define jisdigit    _ismbcdigit
#define jislower    _ismbclower
#define jisspace    _ismbcspace
#define jisupper    _ismbcupper
#define jishira     _ismbchira
#define jiskata     _ismbckata
#define jiskigou    _ismbcsymbol
#define jisprint    _ismbcprint
#define jisl0       _ismbcl0
#define jisl1       _ismbcl1
#define jisl2       _ismbcl2
#define jistojms    _mbcjistojms
#define jiszen      _ismbclegal
#define jmstojis    _mbcjmstojis
#define jtohira     _mbctohira
#define jtokata     _mbctokata
#define jtolower    _mbctolower
#define jtoupper    _mbctoupper
#define hantozen    _mbbtombc
#define zentohan    _mbctombb

#define _fbtom      _fmbsnccnt
#define _fchkctype  _fmbbtype
#define _fjstradv   _fmbsninc
#define _fjstrchr   _fmbschr
#define _fjstrcmp   _fmbscmp
#define _fjstrcspn  _fmbscspn
#define _fjstricmp  _fmbsicmp
#define _fjstrlen   _fmbslen
#define _fjstrlwr   _fmbslwr
#define _fjstrmatch _fmbspbrk
#define _fjstrncat  _fmbsncat
#define _fjstrncmp  _fmbsncmp
#define _fjstrncpy  _fmbsncpy
#define _fjstrnicmp _fmbsnicmp
#define _fjstrnset  _fmbsnset
#define _fjstrrchr  _fmbsrchr
#define _fjstrrev   _fmbsrev
#define _fjstrset   _fmbsset
#define _fjstrskip  _fmbsspnp
#define _fjstrspn   _fmbsspn
#define _fjstrstr   _fmbsstr
#define _fjstrtok   _fmbstok
#define _fjstrupr   _fmbsupr
#define _fmtob      _fmbsnbcnt
#define _fnthctype  _fmbsbtype


/* function prototypes */

#ifdef __cplusplus
}
#endif
