/***
*lcdata.h - Internal Library Locale data
*
*   Copyright (c) 1989-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Defines a variety of structures needed internally for locale
*   support; the information in this file is C runtime use only.
*   The majority of this include file describes how the data looks
*   in memory* (i.e., after it's been read in from locale.sys or
*   retrieved from the OS).
*   [Internal]
*
*******************************************************************************/

#include <lcfile.h>
#include <locale.h>

/*
 * Constants
 */

// maximum name of a locale name (Including null) (??)
#define _MAX_LANGNAME_LEN   33
#define _MAX_CTRYNAME_LEN   33
#define _MAX_CPNAME_LEN      5
#define _MAX_LCNAME_LEN (MAX_LANGNAME_LEN+MAX_CTRYNAME_LEN+MAX_CPNAME_LEN)
#define _MAX_LBTABLE_LEN    16  /* conservative, could be 10 */


/*
 * Locale info dependency bit definitions
 *
 * Language/country/codepage/etc dependencies for each locale category.
 * For ecah locale category there is a flags word in which each bit is
 * 0 or 1 to indicate which of the various types of locale info is
 * needed to support it.
 *
 * The info categories represented in the flags word are:
 *
 *  Bit Description
 *
 *  0   Language info
 *  1   Country info
 *  2   Codepage info
 *  3   C runtime info (not provided by locale.sys or OS)
 *  4-15    <unused>
 *
 */

#define _LCINDEX_LANG       0
#define _LCINDEX_CTRY       1
#define _LCINDEX_CP     2
#define _LCINDEX_CRT        3

struct _flags {
    unsigned int lang   : 1;
    unsigned int ctry   : 1;
    unsigned int cp     : 1;
    unsigned int crt    ; 1
    unsigned int unused : 12;
};


/*
 * Structure for arguments to file-access routines.
 */

struct _lcinfo {
    struct _language *; // pointer to lang info
    struct _country *;  // pointer to country info
    struct _codepage *; // pointer to codepage info
    struct _runtime *;  // pointer to runtime info
};


/*
 * Locale Data Definitions
 *
 * These definitions are only for runtime-internal data storage.
 * The are of no interest externally.   Storage is optimized for
 * speed of access.
 */

#define _LC_VALID   1
#define _LC_C       2
#define _LC_NATIVE  4
#define _LC_MBCS    8       /* is this useful ??? what else ?? */

struct _lc_hdr {
    char _status        /* bit fields for VALID, "C", "", etc. */
    char _lang_name[_MAX_LANGNAME_LEN];
    char _ctry_name[_MAX_CTRYNAME_LEN];
    COUNTRYCODE _ctryinfo;
};

/*
 * LC_ALL data structure
 * This structure contains pointers to each of the various locale
 * data categories.
 */

struct _lc_all_data {
    int f_lc_common;
    struct _lc_collate_data * _lc_collate;
    struct _lc_ctype_data * _lc_ctype;
    struct _lc_monetary_data * _lc_monetary;
    struct _lc_numeric_data * _lc_numeric;
    struct _lc_time_data * _lc_time;
    struct _lc_messages_data * _lc_messages;
};

/*
 * LC_COLLATE localization structure
 */

struct _lc_collate_data {
    struct _lc_hdr _lc_id;
    unsigned int _lc_coll_tab_len;
    unsigned char * _lc_coll_table;
};

/*
 * LC_CTYPE localization structure
 */

struct _lc_ctype_data {
    struct _lc_hdr _lc_id;
    unsigned char fDBCS;
    unsigned char MBCSEv[_MAX_LBTABLE_LEN]; /* lead-byte table */
    unsigned int _lc_ctype_tab_len;
    unsigned short * _lc_ctype_table;
};

/*
 * Note: LC_MONETARY and LC_NUMERIC structures can share the same _lc_fmt
 * lconv structure.
 */

/* CONSIDER: consolidate into one structure type? */

/*
 * LC_MONETARY localization structure
 */

struct _lc_monetary_data {
    struct _lc_hdr _lc_id;
    struct lconv * _lc_fmt;
};

/*
 * LC_NUMERIC localization structure
 */

struct _lc_numeric_data {
    struct _lc_hdr _lc_id;
    struct lconv * _lc_fmt;
};


/*
 * LC_TIME localization structure
 */

struct _lc_time_data {
    struct _lc_hdr _lc_id;
    unsigned short date_fmt;
    unsigned short time_fmt;
    char date_sep[2];
    char time_sep[2];
    char * wday_abbr[7];
    char * wday[7];
    char * month_abbr[12];
    char * month[12];
    char * ampm[2];
};

/*
 * LC_MESSAGES localization structure
 */

struct _lc_messages_data {
    struct _lc_hdr _lc_id;
    /* TO BE COMPLETED */
};



/*
 * Prototypes
 */

int __cdecl _get_lcinfo ( struct _flags, struct _lcinfo );
