/***
*mbctype.h - MBCS character conversion macros
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Defines macros for MBCS character classification/conversion.
*
*******************************************************************************/

/* include the standard ctype.h header file */

#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif

#if (_MSC_VER <= 600)
#define __cdecl     _cdecl
#define __far       _far
#define __near      _near
#endif

#ifndef _MBCS
/*
 * SBCS - Single Byte Character Set
 */

#define _ismbblead(_c)  (0)
#define _ismbbtruelead  (0)

#define _fismbblead(_c)  (0)
#define _fismbbtruelead  (0)

#else

/*
 * MBCS - Multi-Byte Character Set
 */

/*
 * This declaration allows the user access the _mbctype[] look-up array.
 */

extern unsigned char __near __cdecl _mbctype[];

/* bit masks for MBCS character types */

#define _MS 0x01    /* MBCS single-byte symbol */
#define _MP 0x02    /* MBCS punct */
#define _M1 0x04    /* MBCS 1st (lead) byte */
#define _M2 0x08    /* MBCS 2nd byte*/

/* byte types  */

#define _MBC_SINGLE 0       /* valid single byte char */
#define _MBC_LEAD   1       /* lead byte */
#define _MBC_TRAIL  2       /* trailing byte */
#define _MBC_ILLEGAL    -1      /* illegal byte */


/* MBCS character classification function prototypes */

#ifndef _MBCTYPE_DEFINED

/* byte routines */
#ifdef _KANJI
int __cdecl _ismbbkalpha( unsigned short );
int __cdecl _ismbbkana( unsigned short );
int __cdecl _ismbbkpunct( unsigned short );
#endif
int __cdecl _ismbbalpha( unsigned short );
int __cdecl _ismbbpunct( unsigned short );
int __cdecl _ismbbalnum( unsigned short );
int __cdecl _ismbbprint( unsigned short );
int __cdecl _ismbbgraph( unsigned short );

int __cdecl _ismbblead( unsigned short );
int __cdecl _ismbbtrail( unsigned short );

int __far __cdecl _fismbblead( unsigned short );
int __far __cdecl _fismbbtrail( unsigned short );

#define _MBCTYPE_DEFINED
#endif

/*
 * char byte classification macros
 */

#ifdef _KANJI
#define _ismbbkana(_c)  ((_mbctype+1)[(unsigned char)(_c)] & (_MS|_MP))
#define _ismbbkpunct(_c)    ((_mbctype+1)[(unsigned char)(_c)] & _MP)
#define _ismbbkalpha(_c)    ((_mbctype+1)[(unsigned char)(_c)] & _MS)
#define _ismbbalpha(_c) (((_ctype+1)[(unsigned char)(_c)] & (_UPPER|_LOWER))||_ismbbkalpha(_c))
#define _ismbbpunct(_c) (((_ctype+1)[(unsigned char)(_c)] & _PUNCT)||_ismbbkpunct(_c))
#define _ismbbalnum(_c) (((_ctype+1)[(unsigned char)(_c)] & (_UPPER|_LOWER|_DIGIT))||_ismbbkalpha(_c))
#define _ismbbprint(_c) (((_ctype+1)[(unsigned char)(_c)] & (_BLANK|_PUNCT|_UPPER|_LOWER|_DIGIT))||_ismbbkana(_c))
#define _ismbbgraph(_c) (((_ctype+1)[(unsigned char)(_c)] & (_PUNCT|_UPPER|_LOWER|_DIGIT))||_ismbbkana(_c))
#endif

#define _ismbblead(_c)  ((_mbctype+1)[(unsigned char)(_c)] & _M1)
#define _ismbbtrail(_c) ((_mbctype+1)[(unsigned char)(_c)] & _M2)
#define _ismbbtruelead(lb,ch)   (!(lb) && _ismbblead(ch))

#define _fismbblead(_c)  ((_mbctype+1)[(unsigned char)(_c)] & _M1)
#define _fismbbtrail(_c) ((_mbctype+1)[(unsigned char)(_c)] & _M2)
#define _fismbbtruelead(lb,ch)   (!(lb) && _fismbblead(ch))

#ifdef __cplusplus
}
#endif

#endif      /* MBCS */
