/***
*mbdata.h - MBCS lib data
*
*   Copyright (c) 1991-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Defines data for use when building MBCS libs and routines
*
*******************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#if (_MSC_VER <= 600)
#define __cdecl     _cdecl
#define __far       _far
#define __near      _near
#endif

/* validate MBCS defines */
#ifdef _MBCS

#if (!defined(_KANJI) && !defined(_MBCS_OS))
#error Must specify MBCS locale.
#endif

#if (defined(_KANJI) && defined(_MBCS_OS))
#error Can't define _KANJI and _MBCS_OS together.
#endif

#else

#if defined(_KANJI)
#error Can not specify locale without definining _MBCS.
#endif

#if defined(_MBCS_OS)
#error Can not specify locale without definining _MBCS.
#error *** _MBCS_OS NOT IMPLEMENTED ***
#endif

#endif


#ifndef _MBCS

/*
 * SBCS - Single Byte Character Set
 */

#define _ISLEADBYTE(c)  (0)
#define _ISTRAILBYTE(c) (0)

#else

/*
 * MBCS - Multi-Byte Character Set
 */

extern unsigned int near _mbascii;  // flag for handling MB ASCII chars

/*
 * general use macros for model dependent/independet versions.
 */

#ifdef  _MODELINDEP
#define _ISLEADBYTE(c)  _fismbblead(c)
#define _ISTRAILBYTE(c) _fismbbtrail(c)
#else
#define _ISLEADBYTE(c)  _ismbblead(c)
#define _ISTRAILBYTE(c) _ismbbtrail(c)
#endif

/* define char range values */

#ifdef _KANJI

#define _MBASCIILEAD    0x82    /* lead byte value for MB ASCII char */

#define _MBUPPERLOW 0x8260  /* upper case */
#define _MBUPPERHIGH    0x8279
#define _MBLOWERLOW 0x8281  /* lower case */
#define _MBLOWERHIGH    0x829a
#define _MBCASEDIFF 0x21    /* diff between upper and lower case letters */

#define _MBDIGITLOW 0x824f  /* digit */
#define _MBDIGITHIGH    0x8258

#define _MBSPACECHAR    0x8140  /* space */

/* Kanji-specific ranges */
#define _MBHIRALOW  0x829f  /* hiragana */
#define _MBHIRAHIGH 0x82f1

#define _MBKATALOW  0x8340  /* katakana */
#define _MBKATAHIGH 0x8396
#define _MBKATAEXCEPT   0x837f  /* exception */

#define _MBKIGOULOW 0x8141  /* kanji punctuation */
#define _MBKIGOUHIGH    0x81ac
#define _MBKIGOUEXCEPT  0x817f  /* exception */

#endif


#ifdef _MBCS_OS

/*
 * Portable MBCS libs
 */

extern unsigned int _mbcsflag;      // pulls in _mbcsinit code

#endif


#endif      /* MBCS */

#ifdef __cplusplus
}
#endif
