/***
* mbstring.h - MBCS string manipulation macros and functions
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   This file contains macros and function declarations for the MBCS
*   string manipulation functions.
*
*******************************************************************************/

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

#if (_MSC_VER <= 600)
#define __cdecl     _cdecl
#define __far       _far
#endif

#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef _MBCS
/*
 * SBCS - Single Byte Character Set
 */

#define _mbscat     strcat
#define _mbschr     strchr
#define _mbscmp     strcmp
#define _mbscpy     strcpy
#define _mbscspn    strcspn
#define _mbsdec     _strdec
#define _mbsdup     _strdup
#define _mbsicmp    _stricmp
#define _mbsinc     _strinc
#define _mbslen     strlen
#define _mbslwr     strlwr
#define _mbsnbcnt   _strncnt
#define _mbsncat    strncat
#define _mbsnccnt   _strncnt
#define _mbsncmp    strncmp
#define _mbsncpy    strncpy
#define _mbsnextc   _strnextc
#define _mbsnicmp   _strnicmp
#define _mbsninc    _strninc
#define _mbsnset    _strnset
#define _mbsrchr    strrchr
#define _mbsrev     _strrev
#define _mbspbrk    strpbrk
#define _mbsset     _strset
#define _mbsspn     strspn
#define _mbsspnp    _strspnp
#define _mbsstr     strstr
#define _mbstok     strtok
#define _mbsupr     _strupr

/*  Model independent function mappings */

#define _fmbscat    _fstrcat
#define _fmbschr    _fstrchr
#define _fmbscmp    _fstrcmp
#define _fmbscpy    _fstrcpy
#define _fmbscspn   _fstrcspn
#define _fmbsdec    _fstrdec
#define _fmbsdup    _fstrdup
#define _fmbsicmp   _fstricmp
#define _fmbsinc    _fstrinc
#define _fmbslen    _fstrlen
#define _fmbslwr    _fstrlwr
#define _fmbsnbcnt  _fstrncnt
#define _fmbsncat   _fstrncat
#define _fmbsnccnt  _fstrncnt
#define _fmbsncmp   _fstrncmp
#define _fmbsncpy   _fstrncpy
#define _fmbsnextc  _fstrnextc
#define _fmbsnicmp  _fstrnicmp
#define _fmbsninc   _fstrninc
#define _fmbsnset   _fstrnset
#define _fmbsrchr   _fstrrchr
#define _fmbsrev    _fstrrev
#define _fmbspbrk   _fstrpbrk
#define _fmbsspnp   _fstrspnp
#define _fmbsspn    _fstrspn
#define _fmbsset    _fstrset
#define _fmbsstr    _fstrspn
#define _fmbstok    _fstrtok
#define _fmbsupr    _fstrupr

/*  Character function mappings.    */

#define _ismbcalpha isalpha
#define _ismbcdigit isdigit
#define _ismbclegal 1
#define _ismbclower islower
#define _ismbcprint isprint
#define _ismbcspace isspace
#define _ismbcupper isupper

/* SBCS routines needed for MBCS mappings */

unsigned char * __cdecl _strdec(const unsigned char *, unsigned char *);
unsigned char * __cdecl _strinc(unsigned char *);
size_t __cdecl _strncnt(const unsigned char *, size_t);
unsigned int __cdecl _strnextc(const unsigned char *);
unsigned char * __cdecl _strninc(const unsigned char *, size_t);
unsigned char * __cdecl _strspnp(const unsigned char *, const unsigned char *);

/* macro versions of selected functions */

// #define _mbsinc(p)   ((p) ? ++(p) : (p))
// #define _fmbsinc(fp) ((fp) ? ++(fp) : (fp))

#else
/*
 * MBCS - Multi-Byte Character Set
 */

#ifndef _MBSTRING_DEFINED

/* function prototypes */

unsigned short _cdecl _mbbtombc(unsigned short);
int __cdecl _mbbtype(unsigned char, int);
unsigned short _cdecl _mbctombb(unsigned short);
int __cdecl _mbsbtype(const unsigned char *, size_t);
char * __cdecl _mbscat(char *, const char *);
unsigned char * __cdecl _mbschr(const unsigned char *, unsigned short);
int __cdecl _mbscmp(const unsigned char *, const unsigned char *);
char * __cdecl _mbscpy(char *, const char *);
size_t __cdecl _mbscspn(const unsigned char *, const unsigned char *);
unsigned char * __cdecl _mbsdec(const unsigned char *, unsigned char *);
char * __cdecl _mbsdup(const char *);
int __cdecl _mbsicmp(const unsigned char *, const unsigned char *);
unsigned char * __cdecl _mbsinc(unsigned char *);
size_t __cdecl _mbslen(const unsigned char *);
unsigned char * __cdecl _mbslwr(unsigned char *);
size_t __cdecl _mbsnbcnt(const unsigned char *, size_t);
unsigned char * __cdecl _mbsncat(unsigned char *, const unsigned char *, size_t);
size_t __cdecl _mbsnccnt(const unsigned char *, size_t);
int __cdecl _mbsncmp(const unsigned char *, const unsigned char *, size_t);
unsigned char * __cdecl _mbsncpy(unsigned char *, const unsigned char *, size_t);
unsigned int __cdecl _mbsnextc (const unsigned char *);
int __cdecl _mbsnicmp(const unsigned char *, const unsigned char *, size_t);
unsigned char * __cdecl _mbsninc(const unsigned char *, size_t);
unsigned char * __cdecl _mbsnset(unsigned char *, unsigned short, size_t);
unsigned char * __cdecl _mbspbrk(const unsigned char *, const unsigned char *);
unsigned char * __cdecl _mbsrchr(const unsigned char *, unsigned short);
unsigned char * __cdecl _mbsrev(unsigned char *);
unsigned char * __cdecl _mbsset(unsigned char *, unsigned short);
size_t __cdecl _mbsspn(const unsigned char *, const unsigned char *);
unsigned char * __cdecl _mbsspnp(const unsigned char *, const unsigned char *);
unsigned char * __cdecl _mbsstr(const unsigned char *, const unsigned char *);
unsigned char * __cdecl _mbstok(unsigned char *, const unsigned char *);
unsigned char * __cdecl _mbsupr(unsigned char *);

/* model independent function prototypes */

int __far __cdecl _fmbbtype(unsigned char, int);
int __far __cdecl _fmbsbtype(const unsigned char __far *, size_t);
char __far * __far __cdecl _fmbscat(char __far *, const char __far *);
unsigned char __far * __far __cdecl _fmbschr(const unsigned char __far *, unsigned short);
int __far __cdecl _fmbscmp(const unsigned char __far *, const unsigned char __far *);
char __far * __far __cdecl _fmbscpy(char __far *, const char __far *);
size_t __far __cdecl _fmbscspn(const unsigned char __far *, const unsigned char __far *);
unsigned char __far * __far __cdecl _fmbsdec(const unsigned char __far *, unsigned char __far *);
char __far * __far __cdecl _fmbsdup(const char __far *);
int __far __cdecl _fmbsicmp(const unsigned char __far *, const unsigned char __far *);
unsigned char __far * __far __cdecl _fmbsinc(unsigned char __far *);
size_t __far __cdecl _fmbslen(const unsigned char __far *);
unsigned char __far * __far __cdecl _fmbslwr(unsigned char __far *);
size_t __far __cdecl _fmbsnbcnt(const unsigned char __far *, size_t);
unsigned char __far * __far __cdecl _fmbsncat(unsigned char __far *, const unsigned char __far *, size_t);
size_t __far __cdecl _fmbsnccnt(const unsigned char __far *, size_t);
int __far __cdecl _fmbsncmp(const unsigned char __far *, const unsigned char __far *, size_t);
unsigned char __far * __far __cdecl _fmbsncpy(unsigned char __far *, const unsigned char __far *, size_t);
unsigned int __far __cdecl _fmbsnextc (const unsigned char __far *);
int __far __cdecl _fmbsnicmp(const unsigned char __far *, const unsigned char __far *, size_t);
unsigned char __far * __far __cdecl _fmbsninc(const unsigned char __far *, size_t);
unsigned char __far * __far __cdecl _fmbsnset(unsigned char __far *, unsigned short, size_t);
unsigned char __far * __far __cdecl _fmbspbrk(const unsigned char __far *, const unsigned char __far *);
unsigned char __far * __far __cdecl _fmbsrchr(const unsigned char __far *, unsigned short);
unsigned char __far * __far __cdecl _fmbsrev(unsigned char __far *);
size_t __far __cdecl _fmbsspn(const unsigned char __far *, const unsigned char __far *);
unsigned char __far * __far __cdecl _fmbsspnp(const unsigned char __far *, const unsigned char __far *);
unsigned char __far * __far __cdecl _fmbsset(unsigned char __far *, unsigned short);
unsigned char __far * __far __cdecl _fmbsstr(const unsigned char __far *, const unsigned char __far *);
unsigned char __far * __far __cdecl _fmbstok(unsigned char __far *, const unsigned char __far *);
unsigned char __far * __far __cdecl _fmbsupr(unsigned char __far *);

unsigned char __far * __far __cdecl _fmbsdec(const unsigned char __far *, unsigned char __far *);
unsigned char __far * __far __cdecl _fmbsinc(unsigned char __far *);
size_t __far __cdecl _fstrncnt(const unsigned char __far *, size_t);
unsigned int __far __cdecl _fstrnextc(const unsigned char __far *);
unsigned char __far * __far __cdecl _fstrninc(const unsigned char __far *, size_t);
unsigned char __far * __far __cdecl _fstrspnp(const unsigned char __far *, const unsigned char __far *);

/* character routines */

int __cdecl _ismbcalpha(unsigned short);
int __cdecl _ismbcdigit(unsigned short);
int __cdecl _ismbclegal(unsigned short);
int __cdecl _ismbclower(unsigned short);
int __cdecl _ismbcprint(unsigned short);
int __cdecl _ismbcspace(unsigned short);
int __cdecl _ismbcupper(unsigned short);

unsigned short __cdecl _mbctolower(unsigned short);
unsigned short __cdecl _mbctoupper(unsigned short);

#define _MBSTRING_DEFINED
#endif

/* macro versions of selected functions */

// #define _mbsinc(p)      ((_ismbblead(*(p)++)) && (*(p) ) ? ++(p) : (p))
// #define _fmbsinc(fp)    ((_fismbblead(*(fp)++)) && (*(fp) ) ? ++(fp) : (fp))

#endif          /* MBCS */

#ifdef _KANJI

/*  Kanji specific prototypes.  */

int __cdecl _ismbchira(unsigned short);
int __cdecl _ismbckata(unsigned short);
int __cdecl _ismbcsymbol(unsigned short);
int __cdecl _ismbcl0(unsigned short);
int __cdecl _ismbcl1(unsigned short);
int __cdecl _ismbcl2(unsigned short);
unsigned short __cdecl _mbcjistojms(unsigned short);
unsigned short __cdecl _mbcjmstojis(unsigned short);
unsigned short __cdecl _mbctohira(unsigned short);
unsigned short __cdecl _mbctokata(unsigned short);

#endif          /* KANJI */

#ifdef __cplusplus
}
#endif
