/***
*model.h - defined model declarations for use by .asm files
*
*   Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   This file has model declarations for use by .asm files.
*
****/

   /* Small Model Definitions */

#ifdef  M_I86SM
#define  DAT_ADDR_SZ  2             /* 2 byte data addr */
#define  TXT_ADDR_SZ  2             /* 2 byte text addr */
#define  TXT_SEG_ADDR(txtaddr)  ERROR       /* segment part of text addr */
#define  DAT_SEG_ADDR(dataddr)  ERROR       /* segment part of data addr */
#define  CALL  call             /* short call */
#define  RET   ret              /* short return */
#define  JMP   jmp              /* short jump */
#endif  M_I86SM


   /* Middle Model Definitions */

#ifdef  M_I86MM
#define  DAT_ADDR_SZ  2             /* 2 byte data addr */
#define  TXT_ADDR_SZ  4             /* 4 byte text addr */
#define  TXT_SEG_ADDR(txtaddr)  2+txtaddr   /* segment part of text addr */
#define  DAT_SEG_ADDR(dataddr)  ERROR       /* segment part of data addr */
#define  CALL  calli                /* long call */
#define  RET   iret             /* long return */
#define  JMP   jmpi             /* long jump */
#define  PROCDIST  far              /* far procs */
#endif  M_I86MM

   /* Compact Model Definitions */

#ifdef  M_I86CM
#define  DAT_ADDR_SZ  4             /* 4 byte data addr */
#define  TXT_ADDR_SZ  2             /* 2 byte text addr */
#define  TXT_SEG_ADDR(txtaddr)  ERROR       /* segment part of text addr */
#define  DAT_SEG_ADDR(dataddr)  2+dataddr   /* segment part of data addr */
#define  CALL  call             /* near call */
#define  RET   ret              /* near return */
#define  JMP   jmp              /* near jump */
#endif  M_I86CM


   /* Long Model Definitions */

#ifdef  M_I86LM
#define  DAT_ADDR_SZ  4             /* 4 byte data addr */
#define  TXT_ADDR_SZ  4             /* 4 byte text addr */
#define  TXT_SEG_ADDR(txtaddr)  2+txtaddr   /* segment part of text addr */
#define  DAT_SEG_ADDR(dataddr)  2+dataddr   /* segment part of data addr */
#define  CALL  calli                /* long call */
#define  RET   reti             /* long return */
#define  JMP   jmpi             /* long jump */
#define  PROCDIST  far              /* far procs */
#endif  M_I86LM


   /* Big/Little Endian Definitions for longs */

#ifdef  M_I86LE  /* Little Endian (low word at low addr) */
#define  LOWORD(dataddr)  0+dataddr /* addr of low order word of long */
#define  HIWORD(dataddr)  2+dataddr /* addr of hi order word of long */
#endif  M_I86LE

#ifdef  M_I86BE  /* Big Endian (hi word at low addr) */
#define  LOWORD(dataddr)  2+dataddr /* addr of low order word of long */
#define  HIWORD(dataddr)  0+dataddr /* addr of hi order word of long */
#endif  M_I86BE


   /* All Model Definitions */

#define  BPARGBAS  TXT_ADDR_SZ+2    /* offset of first arg from bp */
#define  BXARGBAS  TXT_ADDR_SZ      /* offset of first arg from bx */

#define  TXT_OFF_ADDR(txtaddr)  0+txtaddr
#define  DAT_OFF_ADDR(dataddr)  0+dataddr
