/***
* mtest.h - Multi-thread testing include file
*
*   Copyright (c) 1988-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   This source contains prototypes and definitions used for multi-thread
*   testing.  In order to use the debug flavor of these routines, you
*   MUST link special debug versions of multi-thread crt0dat.obj and
*   mlock.obj into your program.  In addition, mtest.obj contains the
*   routines prototyped in this include file.
*
*   [NOTE:  This source module is NOT included in the C runtime library;
*   it is used only for testing.]
*
*******************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Maximum thread count that mtest.c can handle */
#define _THREADMAX_  64

/* Define thread loop count for mtest.c optional code path */
#define _THREADLOOPCNT_  5

/* sleep macro */
extern unsigned far pascal DOSSLEEP ( unsigned long );
#define _SLEEP_(l)  DOSSLEEP(l)


#ifdef DEBUG
int printlock(int locknum);
int print_single_locks(void);
int print_stdio_locks(void);
int print_lowio_locks(void);
int print_iolocks(void);
int print_locks(void);
#endif

void _print_tiddata(int);

#ifdef __cplusplus
}
#endif
