/***
*os2dll.h - DLL/Multi-thread include
*
*   Copyright (c) 1987-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*
****/

#ifdef __cplusplus
extern "C" {
#endif

#if (_MSC_VER <= 600)
#define __cdecl     _cdecl
#define __far       _far
#define __near      _near
#endif

#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif

/* [NOTE: The following must match the values in os2dll.inc] */

/* Lock symbols */

/* ---- do not change lock #1 without changing emulator ---- */
#define _SIGNAL_LOCK    1   /* lock for signal() & emulator SignalAddress */
                /* emulator uses \math\include\os2dll.inc     */

#define _IOB_SCAN_LOCK  2   /* _iob[] table lock            */
#define _TMPNAM_LOCK    3   /* lock global tempnam variables    */
#define _INPUT_LOCK 4   /* lock for _input() routine        */
#define _OUTPUT_LOCK    5   /* lock for _output() routine       */
#define _CSCANF_LOCK    6   /* lock for _cscanf() routine       */
#define _CPRINTF_LOCK   7   /* lock for _cprintf() routine      */
#define _CONIO_LOCK 8   /* lock for conio routines      */
#define _HEAP_LOCK  9   /* lock for heap allocator routines */
#define _BHEAP_LOCK 10  /* lock for based heap routines     */
#define _TIME_LOCK  11  /* lock for time functions      */
#define _ENV_LOCK   12  /* lock for environment variables   */
#define _EXIT_LOCK1 13  /* lock #1 for exit code        */
#define _EXIT_LOCK2 14  /* lock #2 for exit code        */
#define _THREADDATA_LOCK 15 /* lock for thread data table       */
#define _POPEN_LOCK 16  /* lock for _popen/_pclose database */
#define _SSCANF_LOCK    17  /* lock for sscanf() iob        */
#define _SPRINTF_LOCK   18  /* lock for sprintf() iob       */
#define _VSPRINTF_LOCK  19  /* lock for vsprintf() iob      */
#define _STREAM_LOCKS   20  /* Table of stream locks        */

/* Multi-thread macros, prototypes, and data */

#ifdef DEBUG
#define MAXTHREADID 32  /* max thread id supported by debugging code */
#endif

#ifdef _MT

extern int __far *_threadid;

/* Structure for each thread's data */
/* (NOTE: Definitions must match os2dll.inc) */

struct _tiddata {
    int       _terrno;      /* errno value */
    int       _tdoserrno;   /* _doserrno value */
    unsigned int  _stkhqq;      /* stack limit */
    unsigned int  _fpds;        /* Floating Point data segment */
    unsigned long _holdrand;    /* rand() seed value */
    char __far *    _token;     /* far * to strtok() token */
    /* following pointers get malloc'd at runtime */
    char __far *    _errmsg;    /* far * to strerror()/_strerror() buff */
    char __far *    _namebuf;   /* far * to tmpfile() buffer */
    char __far *    _asctimebuf;    /* far * to asctime() buffer */
    void __far *    _gmtimebuf; /* far * to gmtime() structure */
    void __far *    _stackalloc;    /* far * to thread's stack */
#ifdef  _NOTCXX_
    char _padding[28];      /* pad up to pow2 boundary */
#else   // not _NOTCXX_
    /* far pointers to heap new handlers */
    int (__cdecl __far * __tpnhNearHeap)( size_t );         /* near */
    int (__cdecl __far * __tpnhFarHeap)( size_t );          /* far */
    int (__cdecl __far * __tpnhhHugeHeap)( unsigned long, size_t ); /* huge */
    int (__cdecl __far * __tpnhbBasedHeap)( __segment, size_t );    /* based */
    char _padding[12];      /* pad up to pow2 boundary */
#endif  // not _NOTCXX_
    };

#define  _TIDSIZE 0x40  /* Size of tid data struct rounded up to power of 2 */

/* macros */
#define _lock_fh(fh)            _lock_file(fh)
#define _lock_str(s)            _lock_stream(s)
#define _lock_fh_check(fh,flag)     if (flag) _lock_fh(fh)
#define _mlock(l)           _lock(l)
#define _munlock(l)         _unlock(l)
#define _unlock_fh(fh)          _unlock_file(fh)
#define _unlock_str(s)          _unlock_stream(s)
#define _unlock_fh_check(fh,flag)   if (flag) _unlock_fh(fh)

/* multi-thread routines */
void __cdecl __near _lock(int);
void __cdecl __near _lock_file(int);
void __cdecl __near _lock_stream(int);
void __cdecl __near _unlock(int);
void __cdecl __near _unlock_file(int);
void __cdecl __near _unlock_stream(int);
struct _tiddata __far * __cdecl __near _gettidtab(void);

#ifdef DEBUG
int  __cdecl _check_lock(int);
int  __cdecl _collide_cnt(int);
int  __cdecl _fh_locknum(int);
int  __cdecl _lock_cnt(int);
int  __cdecl _stream_locknum(int);
#endif

#else   /* not _MT */

/* macros */
#define _lock_fh(fh)
#define _lock_str(s)
#define _lock_fh_check(fh,flag)
#define _mlock(l)
#define _munlock(l)
#define _unlock_fh(fh)
#define _unlock_str(s)
#define _unlock_fh_check(fh,flag)

#endif

#ifdef __cplusplus
}
#endif
