/***
* qwin.h - definitions/declarations for QuickWin layer
*
*   Copyright (c) 1990-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   Defines all entry points into the QuickWin layer.
*
****/

#ifndef _QUICKWIN_DEFINED

/* version number */
#define _QWINVER    0

/* defines for buffer size */
#define _QWINBUFINF 0
#define _QWINBUFDEF -1

/* max size for an about box string */
#define _QWINMAXABOUTSTRING 256

/* defines for size/move request */
#define _QWINSIZEMIN        1
#define _QWINSIZEMAX        2
#define _QWINSIZERESTORE    3
#define _QWINSIZECHAR       4

/* defines for what type of info to get from _QWINGetSize */
#define _QWINMAXREQ     100
#define _QWINCURRREQ    101

/* pseudo file handle for frame window */
#define _QWINFRAMEHAND -1

/* defines for _QWINMenuClick */

#define _QWINSTATBAR    1
#define _QWINTILE       2
#define _QWINCASCADE    3
#define _QWINARRANGE    4

/* defines for _QWINSetExit and _QWinGetExit */

#define _QWINEXITPROMPT     1
#define _QWINEXITNOPERSIST  2
#define _QWINEXITPERSIST    3

/* open structure */
struct _QWINopeninfo {
    unsigned int _version;
    const char _far * _title;   /* ptr to win title */
    long _wbufsize;             /* size of win screen buffer */
    };

/* size/move structure */
struct _QWINsizeinfo {
    unsigned int _version;
    unsigned int _type;     /* type of size operation */
    unsigned int _x;        /* x-coordinate, upper left corner */
    unsigned int _y;        /* y-coordinate, upper left corner */
    unsigned int _h;        /* hieght of window */
    unsigned int _w;        /* width of window */
    };

int _far _cdecl _QWINClose( int, int );
void _far _cdecl _QWINExit( int );
long _far _cdecl _QWINGetBuffSize( int );
int _far _cdecl _QWINGetExit( void );
int _far _cdecl _QWINGetFocus( void );
int _far _cdecl _QWINGetSize( int, int, struct _QWINsizeinfo _far * );
int _far _cdecl _QWINInit( char _far *, int, int, HANDLE, int );
int _far _cdecl _QWINIsQWin( int );
int _far _cdecl _QWINMenuClick( int );
int _far _cdecl _QWINOpen( struct _QWINopeninfo _far *, struct _QWINsizeinfo _far * );
int _far _cdecl _QWINRead( char _far *, int, int );
int _far _cdecl _QWINSetAboutString( char _far * );
int _far _cdecl _QWINSetBuffSize( int, long );
int _far _cdecl _QWINSetExit( int );
int _far _cdecl _QWINSetFocus( int );
int _far _cdecl _QWINSetSize( int, struct _QWINsizeinfo _far *  );
int _far _cdecl _QWINTerm( void );
int _far _cdecl _QWINWrite( char _far *, int, int, int );
void _far _cdecl _QWINYield( void );

void _far _fortran YIELDQQ( void ); /* temporary declaration */

#define _QUICKWIN_DEFINED
#endif
