/***
*sizeptr.h - defines constants based on memory model
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   This file defines the constants SIZEC, SIZED, DIST, BDIST based
*   on the current memory model.
*   SIZEC is for far code models (medium, large).
*   SIZED is for large data models (compact, large).
*   [Internal]
*
****/

#if (_MSC_VER <= 600)
#define __far       _far
#define __near      _near
#endif

#ifdef M_I86MM
#undef SIZED
#define SIZEC
#endif

#ifdef M_I86CM
#undef SIZEC
#define SIZED
#endif

#ifdef M_I86LM
#define SIZEC
#define SIZED
#endif

#ifdef SS_NE_DS
#define SIZED
#endif

#ifdef SIZED
#define DIST  __far
#define BDIST __near    /*bizzare distance*/
#else
#define DIST  __near
#define BDIST __far /*bizzare distance*/
#endif
