/***
*syserr.h - constants/macros for error message routines
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   This file contains macros/constants for perror, strerror,
*   and _strerror.
*   [Internal]
*
****/

/* Macro for perror, strerror, and _strerror */

#define _sys_err_msg(m) _sys_errlist[(((m)<0)||((m)>=_sys_nerr)?_sys_nerr:(m))]

/* Maximum length of an error message.
   NOTE: This parameter value must be correspond to the length of the longest
   message in _sys_errlist (source module syserr.c). */

#define _SYS_MSGMAX 32
