	page	,132
	title	addlist - Add memory to linked heap list
;***
;addlist.asm - Add memory to linked heap list
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Add a block of memory to a linked heap list.
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

externNP _addseg			; add memory to a heap segment
externNP _findseg			; find a heap segment
externNP _initseg			; initialize a heap segment
externNP _linkseg			; link a heap segment into a list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;_addlist - Add memory to linked heap list
;
;Purpose:
;	Add supplied memory to the supplied linked heap list
;
;Entry:
;	ds:bx = linked heap list
;	es:si = new memory block
;	cx = size of new block
;
;	NOTES:
;	(1) Pointer es:si is assumed to be even.
;	(2) Size cx is assumed to be even
;
;Exit:
;	carry clear = success
;	carry set   = failure
;
;Uses:
;
;Preserves:
;	ds
;Exceptions:
;
;*******************************************************************************

cProc	_addlist,<PUBLIC,NEAR>,<ds>

cBegin	<nogen>

	push	ds			; save caller's ds

;
; *** SHOULD WE (RE)SET ROVERSEG POINTER ???
;

;
; See if we have a segment for this block already in our linked list
;

	mov	ax,es		; ax = new block segment
	push	cx		; save block size
	call	_findseg	; search for the segment
	pop	cx		; restore block size
	jc	add_newseg	; jump, if we didn't find it
	;fall thru		; found it!

;
; Found a segment in the list that corresponds to the new block
; ds:bx = heap segment
; si = pointer to new block
; cx = size of new block
;
	call	_addseg 	; add the block to the heap segment
	jmp	short done	; all done (return carry)

;
; --- Error Return
;

error_rtn:
	stc			; carry set = error
	jmp	short done	; join common return

;
; The new block's segment is NOT in the heap list; add it.
; ds:bx = heap list header
; es:si = new block
; cx = block size
;

add_newseg:
	cmp	cx,_HEAP_MINSEG ; minimum size of a heap descriptor
	jb	error_rtn	; too small - throw it back

	;shuffle some pointers
	push	ds
	mov	ax,es
	mov	ds,ax
	assumes ds,nothing
	mov	di,bx
	mov	bx,si		; ds:bx = heap segment descriptor
	pop	es		; es:di = heap list header

	;init the new heap segment
	mov	ax,es:[di].segflags		    ; get segment flags
	and	al,not (_HEAP_MODIFY OR _HEAP_FREE) ; mask off free/mod bits
	mov	ds:[bx].flags,ax		    ; _addheap seg flags

	mov	ax,cx		; ax = size of segment
	call	_initseg	; initialize the new segment

	;link the new segment into the appropriate heap list
	call	_linkseg	; link it in

	;fall thru

;
; --- Good return
;

good_rtn:
	clc			; carry clear = success
	;fall thru

;
; Common return
; ax = return value

done:
	pop	ds		; restore caller's ds
	ret

cEnd	<nogen>

sEnd	code

	end
