	page	,132
	title	alloca - stack frame allocator
;***
;alloca.asm - stack frame allocator
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines alloca() - allocate memory from stack frame
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include infoseg.inc
include os2dll.inc

.list


sBegin	data
assumes ds,data

extrn	_STKHQQ:word		 ; stack bottom check value

sEnd	data


sBegin	code
assumes cs,code
assumes ds,data

page
;***
;char *_alloca(size) - allocate bytes from the stack frame
;
;Purpose:
;	Allocate memory from the stack frame.  The allocated space is
;	automatically freed when the function that called alloca is exited.
;
;	NOTE:  The operation of alloca() is closely tied to the frame setup
;	produced by the compiler.  Alloca() currently assumes the following:
;
;		(1) The routine that calls alloca() was compiled with
;		optimization disabled (e.g., -Od).  This ensures that
;		the bp/sp save/restore instructions are generated, that
;		the registers are saved in a predictable place, etc.
;
;		(2) The compiler saves at most 5 registers on the top
;		of the stack (i.e., sp relative).  One way to cause the
;		the compiler to save 5 registers is with "_fastcall
;		_loadds -Gs" (register based calling, no stack checking,
;		load ds on entry).
;
;		[Though the _saveregs and _interrupt directives save more
;		than 5 registers, they are not on top of the stack, so
;		alloca() works fine.]
;
;Entry:
;	unsigned int size - # of bytes to allocate
;
;Exit:
;	returns DX:AX = pointer to allocated memory on stack
;	returns DX:AX = 0 if unable to allocate
;
;	What is expected to be the saved copies of 5 registers
;	have been copied onto the new stack frame. If those
;	registers were not saved, this just takes up 10 bytes
;	on the stack but does no harm.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

labelP	<PUBLIC,_alloca>

	pop	cx		; cx = return offset
if	sizeC
	pop	dx		; dx = return segment
endif
	pop	ax		; ax = size to allocate
	inc	ax
	and	al,not 1	; make it even
	mov	bx,sp

ifdef	_LOAD_DGROUP
	push	ds
	push	DGROUP		; don't have a register to trash
	pop	ds
endif	;_LOAD_DGROUP

	sub	bx,ax		; ss:bx = base address
	jb	nostack 	;   stack overflow

	cmp	bx,[_STKHQQ]
	jb	nostack

ifdef _LOAD_DGROUP
	pop	ds
endif	;_LOAD_DGROUP

	xchg	sp,bx		; ss:sp = base address	ss:bx = old
	mov	ax,sp		; ax = base offset

	push	ss:[bx+8]
	push	ss:[bx+6]
	push	ss:[bx+4]
	push	ss:[bx+2]
	push	ss:[bx] 	; push possible save values of 5 registers

if	sizeC
	mov	bx,dx		; (bx):cx = return address
endif
	mov	dx,ss		; dx:ax = base address

allocaxit:
	push	ax		; restore stack for caller pop
if	sizeC
	push	bx
	push	cx
	retf			; far return
else
	jmp	cx		; near "return"
endif

nostack:

ifdef _LOAD_DGROUP
	pop	ds
endif	;_LOAD_DGROUP

if	sizeC
	mov	bx,dx		; (bx):cx = return address
endif
	xor	ax,ax
	cwd
	jmp	allocaxit	; return with 0:0

sEnd	code

	end
