	page	,132
	title	bcalloc -- Allocate array storage on the based heap
;***
;bcalloc.asm - Allocate array storage on the based heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Allocate array storage on the based heap
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

	externP _bmalloc			; based heap allocation

sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;_bcalloc() - Allocate array storage on the based heap
;
;Purpose:
;	Allocate array storage on the based heap.  Each
;	element of the allocate array is initialized to 0.
;
;Entry:
;	unsigned bseg	 = based segment
;	unsigned nelem	 = number of elements
;	unsigned elsize  = size of each element
;
;Exit:
;	unsigned offset = success = offset to allocated memory
;			  failure = NULL (insufficient memory)
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_bcalloc,<PUBLIC>,<di>

	parmW	bseg		; based heap segment
	parmW	nelem		; number of array elements
	parmW	elsize		; element size

cBegin

;
; Calculate how big a chunk of memory to get
;

	mov	ax,[nelem]	; number of elements
	mul	[elsize]	; dx:ax = <nelem> * <elsize>
	jnc	get_array	; if < 64k, continue
	;fall thru		; product > 64k, error

;
; Error return
;
	mov	ax,_NULLOFF
	mov	dx,bseg 	; return bseg:_NULLOFF on failure
	jmp	short done

;
; Call _bmalloc() to get the memory
; ax = size of array
;

get_array:
	push	ax		; size on stack
	push	[bseg]		; push based segment value

	call	_bmalloc	; get the memory from the far heap

	pop	cx		; pop off segment (throw away)
	pop	cx		; cx = requested size
	cmp	ax,_NULLOFF	; did _bmalloc fail?
	je	done		; yes, return error

;
; Fill the newly allocated block with zeros
; dx:ax = address of block
; cx = byte size
;

	push	ax		; preserve ax

	mov	es,dx		; es:di = address
	mov	di,ax
	xor	ax,ax		; ax = 0 = fill value / cx = count
	inc	cx		; cx = an even word count
	shr	cx,1
	rep	stosw		; store the bytes

	pop	ax		; restore dx:ax
	;fall thru

;
; Common return
; dx:ax = return value
;

done:

cEnd	<nolocals>

sEnd	code

	end
