	page	,132
	title	bdata - Based heap data
;***
; bdata.asm - Based heap data
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains data used by the based heap.
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

; --- Based heap linked list header ---

labelW	<PUBLIC,_bheap> 	; Based heap link descriptor
	_heap_list_desc <0,0,0,_HEAP_MODIFY OR _HEAP_BASED>

sEnd	data


ifdef _WINDLL

externNP _freelist			; free up a heap list

sBegin	code
	assumes cs,code
	assumes ds,nothing

page
;***
; _freebasedheap - Free all based heap memory to OS
;
;Purpose:
;	This routine frees all based heap memory to the OS.
;
;	[It is currently used in _WINDLL models because
;	GlobalMemory is not automatically reclaimed by Windows
;	if it is shared (which the Win DLL lib memory is).
;
;Entry: void
;
;Exit:	void
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_freebasedheap,<PUBLIC,NEAR>,<>

cBegin	<nolocals>

	mov	bx,dataoffset _bheap
	push	ds
	pop	es			; es:bx = based heap list header
	call	_freelist		; free up all based heap memory

cEnd <nolocals>

sEnd	code

endif	;_WINDLL


	end
