	page	,132
	title	bexpand - C runtime based heap expand
;***
;bexpand.asm - based heap block expansion
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _bexpand() - expand (contract) a block in the based heap.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _bheap 		; near heap segment descriptor

sEnd	data


externNP _resize
externNP _findseg

sBegin	code
	assumes cs,code
	assumes ds,data

;***
;void _based(bseg) *
;_bexpand(_seg bseg, void _based(bseg) *bheapblk, size_t newsize) - expand
;(contract) a block in the based heap
;
;Purpose:
;	Expand (contract) the specified block in the based heap to newsize.
;	If the block is successfully resized, bheapblk is returned. If not
;	successful, the block is expanded as much as possible and NULL is
;	returned. If an error occurs, NULL is returned and errno is set to
;	*** E_?????? ***.
;
;	_bmsize can be used to determine the new size
;
;	_bexpand does not change the free/inuse status of the block
;
;Entry:
;	_seg bseg			 - based heap segment
;	void _based(bseg) user *bheapblk - pointer to based heap block to be
;					   expanded + 2
;	size_t newsize			 - new size for block
;
;Exit:
;	returns bheapblk if successful
;	returns NULL if not successful
;	errno set to *** E_?????? *** if an error occurs
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

cProc	_bexpand,<PUBLIC>,<si,di>


	parmW	bseg
	parmW	bheapblk
	parmW	newsize

cBegin
	mov	bx,dataOFFSET _bheap
	mov	ax,[bseg]
	push	ds			; save DGROUP for return
	assumes ds,nothing
	call	_findseg		; _findseg preserves es and si
	jc	bad_ret
	mov	si,[bheapblk]
	push	si
	mov	cx,[newsize]
	call	_resize
	pop	ax
	pop	ds
	jc	bad_ret1
	jmp	short good_ret
bad_ret:
;	*** SHOULD ERRNO BE SET TO E_?????? HERE? ***
	pop	ds			; restore DGROUP
bad_ret1:
	mov	ax,_NULLOFF		; return bseg:_NULLOFF for failure
good_ret:
	mov	dx,[bseg]
cEnd	<nolocals>

sEnd	code
	end
