	page	,132
	title	bfreeseg - Unlink and free a based heap segment

;***
;bfreeseg.asm - Unlink and free a based heap segment
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Contains _bfreeseg routine that unlinks and a frees the specified
;	segment in the based heap.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _bheap

sEnd	data


externNP _findseg
externNP _unlinkseg

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;int _bfreeseg(_seg bheapseg)
;
;Purpose:
;	Unlink and free the specified heap segment from the based heap.
;
;Entry:
;	bheapseg - selector value for a segment in the based heap
;
;Exit:
;	return value =	0, if no error has occurred
;		     = -1, if an error has occurred (errno will be set to
;			   E_??????)
;
;Uses:
;	ax, bx, cx, dx, es
;
;Preserves:
;	si, di, ds
;
;*******************************************************************************


;--- Single thread version

cProc	_bfreeseg,<PUBLIC>,<si,di>


	parmW	bheapseg

cBegin

; First, verify the supplied selector value represents a segment in the
; based heap and get a pointer to its descriptor.

	mov	ax,[bheapseg]
	mov	bx,dataOFFSET _bheap

; Note that the code belows depends on _findseg preserving dx and di!

	mov	dx,ds
	mov	di,bx			; dx:di = pointer to _bheap
	call	_findseg		; if successful, ds:bx will come back
					; pointing to the heap seg descriptor
	assumes ds,nothing
	jc	error_ret		; seg not in list, go return an error
					; (note that ds:bx was unchanged in
					; case)

; Now, unlink and free the heap segment with a call to _unlinkseg. Note that
; since the call to _findseg was successful, ds:bx = pointer to heap segment
; descriptor.

	mov	es,dx			; es:di points to _bheap
	call	_unlinkseg		; note that _unlinkseg returns ds:bx
	assumes ds,data 		; pointing to _bheap
	jc	error_ret1
	xor	ax,ax			; return 0 to indicate success
	jmp	short done

error_ret:
	;*** CODE TO SET ERRNO TO E_?????? GOES HERE ***

; Set ax to -1 to indicate an error and return.

error_ret1:
	mov	ax,-1

done:
cEnd	<nolocals>

sEnd	code
	end
