	page	,132
	title	bheapadd - Add memory to based heap
;***
;bheapadd.asm - Add memory to based heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Add a block of memory to the based heap.
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _bheap			; based heap list

sEnd	data

externNP _addlist		; add memory to linked heap list


sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;_bheapadd - Add memory to the based heap
;
;Purpose:
;	Add supplied memory to the based heap
;
;Entry:
;	unsigned bseg = segment of block
;	unsigned boff = offset of block
;	size_t blocksize  = size of block
;
;	Both bseg and blocksize must be even or _bheapadd will
;	return an error.
;
;Exit:
;	ax =  0 = success
;	   = -1 = failure
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version
cProc	_bheapadd,<PUBLIC>,<si,di>


	parmW	bseg		; based heap segment
	parmW	boff		; offset into based heap segment
	parmW	blocksize	; size of block

cBegin

;
; Validate input values
;

	mov	es,[bseg]	; es:si = address
	mov	si,[boff]
	test	si,1		; is it even ??
	jnz	error_rtn	; nope - error
	mov	cx,[blocksize]	; cx = block size
	test	cl,1		; is it even ??
	jz	add_bheap	; yes, continue
	;fall thru		; nope - error

;
; --- Error return
;

error_rtn:
	mov	ax,-1			; ax = -1 = error
	jmp	short done		; join common return

;
; Add block of memory to based heap
; es:si = new memory block
; cx = size
; ds = dgroup
;

add_bheap:
	mov	bx,dataoffset _bheap	; based heap list header
	call	_addlist		; add block to list
	jc	error_rtn		; error
	;fall thru

;
; --- Good return
;

good_rtn:
	xor	ax,ax			; ax = 0 = good return
	;fall thru

done:

cEnd	<nolocals>

sEnd	code

	end
