	page	,132
	title	bheapchk -- Check the based heap
;***
;bheapchk.asm - Check the based heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Check the based heap.
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _bheap 			; based heap linked list header

sEnd	data

externNP _findseg			; find a heap segment
externNP _setseg			; check/set a heap segment
externNP _setlist			; check/set a list of heap segs


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;unsigned _bheapchk(unsigned) - Miminal validity check on the based heap
;
;Purpose:
;	Perform a minimal consistency check on the based heap.
;	If the user supplies a based heap segment, validate that segment
;	only.  If the supplied segment is NULL, validate the whole based
;	heap.
;
;Entry:
;	unsigned = based heap segment or 0 (for all segments)
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPOK 	 - completed okay
;	_HEAPEMPTY	 - based heap not initialized
;	_HEAPBADBEGIN	 - can't find initial header info
;	_HEAPBADNODE	 - malformed node somewhere
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version
cProc	_bheapchk,<PUBLIC>,<si,di>


	parmW	bseg			; based segment

cBegin

	mov	ax,[bseg]		; ax = based segment value
	mov	cx,_HEAPSET_NOFILL	; cx = don't fill the free blocks
	;fall through

;
; --- Both _bheapchk and _bheapset enter here ---
; ax = based segment value
; cx = fill value or _HEAPSET_NOFILL
;

common:
	mov	di,dataoffset _bheap	; ds:di = based heap header
	or	ax,ax			; user supply a segment value ??
	jnz	one_seg 		; yes, check/set one segment only
	;fall thru			; no, do all based segments

;
; --- Check/set all based segments ---
; ax = 0
; cx = fill value
; ds:di = based heap list header
;

all_segs:
	call	_setlist		; check/set all based segments
	jmp	short done		; join common exit

;
; --- Error ---
;

error_rtn:				; did not find segment
	pop	ds			; restore dgroup
	mov	ax,_HEAPBADPTR		; bad pointer from user
	jmp	short done		; join common return

;
; --- Check/set a single based segment ---
; ax = based segment
; cx = fill value
; ds:di = based heap list header
;

one_seg:
	push	ds			; save dgroup
	mov	dx,cx			; save fill value
	mov	bx,di			; bx = based heap list descriptor
	call	_findseg		; find the based segment
	jc	error_rtn		; error, did not find segment

	mov	cx,dx			; cx = fill value / ds:bx = heap desc
	call	_setseg 		; check/set the based segment
	pop	ds			; restore dgroup
	;fall thru

;
; Common exit
;

done:

cEnd	<nolocals>


page
;***
;int _bheapset(unsigned, unsigned) - Set contents of free based heap blocks
;
;Purpose:
;	Fill all the free blocks in the based heap with the
;	supplied value.  Also, perform some heap consistency
;	checks while we're at it.
;
;	If the user supplies a based heap segment, fill that segment
;	only.  If the supplied segment is NULL, fill the whole based
;	heap.
;Entry:
;	unsigned = based heap segment or 0 (for all segments)
;	unsigned = fill value
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPOK 	 - completed okay
;	_HEAPEMPTY	 - based heap not initialized
;	_HEAPBADBEGIN	 - can't find initial header info
;	_HEAPBADNODE	 - malformed node somewhere
;	_HEAPBADPTR	 - bad pointer
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version
cProc	_bheapset,<PUBLIC>,<si,di>


	parmW	bseg			; based segment
	parmW	fill			; fill value

cBegin

	mov	ax,[bseg]		; ax = based segment value
	mov	cx,[fill]		; cx = fill value
	jmp	short common		; join _bheapchk

cEnd	<nogen>

sEnd	code

	end
