	page	,132
	title	bheapmin - Minimize the based heap

;***
;bheapmin.asm - Minimize the based heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Contains _bheapmin, the function that minimizes the based heap
;	segments.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _bheap				; based heap list descriptor

sEnd	data


externNP _findseg			; find segment in heap seg list
externNP _searchseg			; coalesce free blocks
externNP _minseg			; minimize a heap segment

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;int _bheapmin(_seg bheapseg) - Minimize the based heap
;
;Purpose:
;	If bheapseg is 0, walk the list of segments in the based heap and
;	'minimize' each one. If bheapseg is non-zero, it is the selector
;	for a based heap segment, 'minimize it.
;
;Entry:
;	bheapseg = 0 (minimize all segments in the based heap) or,
;		 = selector value for segment to minimize
;
;Exit:
;	return value =	0, if no error has occurred
;		     = -1, if an error has occurred (in this case, errno
;			   will have been set by one of the helper routines)
;
;Uses:
;	everything except si, di, ds (which are explicitly saved and restored)
;
;Preserves:
;	si, di, ds
;
;Notes:
;	Based heap segments are never freed (i.e., unlinked from the based
;	heap list and released back to the OS) by _bminseg. However, there
;	is no explicit code (and none is required) to ensure this. It falls
;	out this way because the _HEAP_FREE flag is never set in a based
;	heap segment descriptor (see bdata.asm).
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

cProc	_bheapmin,<PUBLIC>,<si,di,ds>


	parmW	bheapseg

cBegin

; Minimize just one segment or every segment in the heap list?

	mov	cx,[bheapseg]
	jcxz	min_list

; Just minimize the supplied segment.

; Validate the selector value and get far pointer to the heap seg desc

	xchg	ax,cx			; ax = selector value of segment
	mov	bx,dataOFFSET _bheap
	push	ds
	push	bx			; push far pointer to _bheap on stack
	call	_findseg		; (if successful, ds:bx comes back
					; pointing to heap seg descriptor)
	assumes ds,nothing
	jc	error_ret		; error! (ds:bx unchanged)

; Coalesce blocks within the segment as much as possible.

	mov	cx,_HEAP_COALESCE
	call	_searchseg

; Minimize the segment.

	pop	di
	pop	es			; es:di = pointer to _bheap
	call	_minseg
	jc	error_ret
	jmp	short good_ret

; min_list
; Walk the list of based heap segments. For each segment, coalesce the
; free blocks and 'minimize' the segment.

min_list:
	assumes ds,data
	push	ds
	pop	es
	mov	di,dataOFFSET _bheap	; es:di = pointer to _bheap
					; *** ABOVE MUST BE CHANGED FOR DLL ***
	lds	bx,_bheap.startseg	; get first based heap seg
	assumes ds,nothing

minimize:
	mov	cx,ds
	jcxz	good_ret		; empty list, we're done
	mov	cx,_HEAP_COALESCE
	push	es
	push	di			; save es:di across call
	call	_searchseg		; coalesce the segment amap
	pop	di
	pop	es			; es:di = pointer to _bheap (again)
	push	word ptr ds:[bx].nextseg+2 ; push far pointer to next heap
	push	word ptr ds:[bx].nextseg   ; segment descriptor onto stack
	push	es
	push	di			; save es:di across call
	call	_minseg
	pop	di
	pop	es			; es:di = pointer to _bheap (again)
	pop	bx
	pop	ds			; ds:bx = ptr to next heap seg desc
	jc	error_ret		; error!
	jmp	short minimize

error_ret:
	mov	ax,-1			; return -1 to indicate error
	jmp	short done

good_ret:
	xor	ax,ax			; return 0 to indicate success

done:
cEnd	<nolocals>

sEnd	code
	end
