	page	,132
	title	bheapseg - Allocate a based heap segment
;***
;bheapseg.asm - Allocate a based heap segment
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Allocate a based heap segment of the requested size.
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _bheap 			; based heap linked list descriptor

sEnd	data

externNP _newseg			; get a new heap segment


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
; bheapseg - Allocate a based heap segment
;
;Purpose:
;	Allocate a based heap segment of the requested size.
;
;Entry:
;	unsigned int incr = size of segment
;
;Exit:
;	ax = success = segment selector
;	     failure = NULL
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version
cProc	_bheapseg,<PUBLIC>,<si,di>


	parmW	incr		; unsigned int segment size

cBegin

;
; Validate requested segment size
;

	mov	cx,[incr]	; cx = request size
	jcxz	error_rtn	; error, if zero
	cmp	cx,_HEAP_MAXREQ ; cx > maximum legal request size ??
	ja	error_rtn	; yes, return error

;
; Get a new segment, init it, and link it into the based heap list.
; cx = request size
;

	mov	ax,ds			; es = dgroup
	mov	es,ax
	mov	di,dataoffset _bheap	; es:di = heap list header
	push	ds			; save dgroup
	call	_newseg 		; let _newseg do all the work
	mov	ax,ds			; ax = new segment selector
	pop	ds			; restore dgroup
	jnc	udone			; good return
	;fall thru			; error return


;
; Error return
;

error_rtn:
	xor	ax,ax			; ax = 0
	;fall thru

;
; Common return
; ax = return value
;

udone:

cEnd	<nolocals>

sEnd	code

	end
