	page	,132
	title	bheapwalk -- Walk the based heap
;***
;bheapwalk.asm - Walk the based heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list


sBegin	data
	assumes ds,data

externW  _bheap 			; based heap linked list header

sEnd	data

externNP _walklist			; walk a linked list of heap segs
externNP _walkseg			; walk a heap segment
externNP _findseg			; find a heap segment


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;int _bheapwalk(segment, &_heapinfo) - Walk the based heap
;
;Purpose:
;	Get the next based heap entry (along with size and used/free
;	status).  If _heapinfo._pentry == NULL, return information
;	about the first entry in the heap.
;
;Entry:
;	bseg = based heap segment or 0 (report on all based heap segs)
;
;	&_heapinfo = address of a _heapinfo structure (possibly returned
;		by a previous call to _bheapwalk).  The contents are:
;
;		_pentry = pointer to heap entry (could be NULL)
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPEMPTY	- based heap not initialized
;	_HEAPBADBEGIN	- can't find initial header info
;	_HEAPBADNODE	- malformed node somewhere
;	_HEAPOK 	- heap ok
;	_HEAPEND	- end of heap reached
;
;	Fills in the _heapinfo structure as follows:
;
;		_pentry = pointer to heap entry
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version
cProc	_bheapwalk,<PUBLIC>,<si,di>


	parmW	bseg			; based heap segment
	parmDP	address 		; address of _heapinfo struct

cBegin

;
; Get based heap header and _heapinfo address
;

	mov	bx,dataoffset _bheap	; ds:bx = based heap header

if	sizeD
	les	di,[address]		; es:di = address of heapinfo struct
else
	mov	di,[address]		; es:di = address of heapinfo struct
	mov	ax,ds
	mov	es,ax
endif

;
; Get segment and see if it's 0 or not
; ds:bx = based heap list header
; es:di = &_heapinfo
;

	mov	ax,[bseg]		; supplied segment
	or	ax,ax			; is it 0 ??
	jnz	one_seg 		; yes, check/set one segment only
	;fall thru			; no, do all based segments

;
; Report on all based heap entries in all segments
; ds:bx = based heap header
; es:di = heapinfo address
;

all_segs:
	call	_walklist		; walk based heap
	jmp	short done		; join common exit

;
; --- Error ---
;

error_rtn:				; did not find segment
	pop	ds			; restore dgroup
	mov	ax,_HEAPBADPTR		; bad pointer from user
	jmp	short done		; join common return

;
; --- Check/set a single based segment ---
; ax = based segment
; ds:bx = based heap list header
; es:di = &_heapinfo structure
;

one_seg:
	push	ds			; save dgroup
	call	_findseg		; find the based segment
	jc	error_rtn		; error, did not find segment

	call	_walkseg		; walk the segment
	pop	ds			; restore dgroup
	;fall thru

;
; Common return
; ax = return value
;

done:

cEnd	<nolocals>

sEnd	code

	end
