	page	,132
	title	bmsize - C runtime based heap size
;***
;bmsize.asm - based heap size
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _bmsize() - based heap memory block size
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
.list


sBegin	code
assumes	ds,data
assumes	cs,code

page
;***
;unsigned _bmsize(bseg, uoff) - return based heap memory block size
;
;Purpose:
;	Returns the size in bytes of a memory block in the based heap
;	allocated by _umalloc().
;
;Entry:
;	unsigned bseg = based heap segment
;	unsigned uoff = offset into segment
;
;Exit:
;	returns size in bytes (unsigned)
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


cProc	_bmsize,<PUBLIC>,<>

	parmW	bseg			; segment
	parmW	uoff

cBegin

	mov	es,[bseg]	; es:bx = address of based heap entry
	mov	bx,[uoff]
	mov	ax,es:[bx-2]
	and	al,not 1	; make even

cEnd	<nolocals>

sEnd	code

	end
