	page	,132
	title	brealloc - Reallocate a based heap block to a new size

;***
;brealloc.asm - Reallocate a block in the based heap to a new size.
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _brealloc() - reallocate a block in the based heap to a
;	new size.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _bheap

sEnd	data

externP  _bmalloc
externP  _bfree

externNP _resize
externNP _findseg

sBegin	code
	assumes cs,code
	assumes ds,data

;***
;void _based(bseg) *
;_brealloc(_seg bseg, void _based(bseg) *bheapblk, size_t newsize)
;
;Purpose:
;	Change the size of the specified block in the based heap. First try
;	to resize the block in place (i.e., expand/contract it to newsize).
;	If this fails, try to allocate a new block of size newsize, copy
;	over the contents of the old block and free the old block.
;
;Entry:
;	_seg bseg		    - based heap segment
;	void _based(seg) *bheapblk  - pointer to block in the based heap + 2 (i.e.,
;				      pointer to the allocation area of a block)
;	size_t newsize		    - desired new size of the block
;
;Exit:
;	returns pointer to the new, or newly resized, block if successful
;	returns NULL if not successful, in the case the original block is
;	not altered
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

cProc	_brealloc,<PUBLIC>,<si,di,ds>


	parmW	bseg
	parmW	bheapblk
	parmW	newsize

cBegin
	mov	si,[bheapblk]
	mov	ax,[bseg]
	mov	cx,[newsize]

; bheapblk == NULL is a special case: to conform with ANSI, the semantics are
; identical to _bmalloc(bseg, newsize).  In the spirit of ANSI, we check for
; _NULLOFF as well.

	or	si,si			; NULL pointer?
	jz	do_bmalloc		;   yes, go allocate a new block
	cmp	si,_NULLOFF		; _NULLOFF pointer?
	je	do_bmalloc		;   yes, go allocate a new block

; bheapblk != NULL, newsize == 0 is another special case: to conform with
; ANSI, the semantics are to _bfree the block and return NULL.

	jcxz	do_bfree		;   newsize is 0, go free the block

; Fetch the heap segment descriptor for the segment containing the block

	mov	di,ds			; stash DGROUP in di for a while
	mov	bx,dataOFFSET _bheap
	push	cx			; save [newsize] value across call
	call	_findseg		; returns ds:bx pointing to descriptor
	pop	cx
	assumes ds,nothing		; so that ds == bseg (if successful)

;	*** SHOULD WE JUMP TO A ROUTINE THAT SETS ERRNO TO E_?????? BEFORE
;	*** RETURNING NULL?

	jc	ret_null		; return NULL to caller

; First try resizing the original block. Note that if newsize <= original size
; of the block, this always works.

	push	[si-2]			; save original header on stack
	push	cx			; save [newsize] value across call
	call	_resize
	pop	cx
	jc	try_bmalloc		; failed, go try to get a new block
	mov	ax,si			; return bheapblk
	and	byte ptr [si-2],not 1	; make sure block is marked inuse
	pop	cx			; clean up stack
	jmp	short done

; try_bmalloc
; Try to allocate a new block of the specified size. If successful, copy the
; contents of the old block to the new block and free the old block.

try_bmalloc:
	push	ds			; save pointer to heap segment...
	push	bx			; ...descriptor
	push	cx			; push newsize arg
	push	ds			; push bseg arg
	mov	ds,di			; restore ds to DGROUP

	callcrt _bmalloc

	add	sp,4			; clean up stack
	pop	bx			; restore pointer to heap...
	pop	ds			; ...segment descriptor
	pop	cx			; retrieve original header
	and	cl,not 1		; cx = size of original block
	cmp	ax,_NULLOFF		; was _bmalloc successful?
	je	failure 		;   no, go clean up and fail
	xchg	ax,di			; stash DGROUP in ax and set
	mov	dx,ds
	mov	es,dx			; es:di = pointer to new block + 2
	cld
	push	di			; save offset pointer to new block + 2
	push	si			; save offset pointer to old block + 2
	push	ds			; save bseg
	shr	cx,1
	rep	movsw			; move (original block size)/2 words
	mov	ds,ax			; restore ds to DGROUP again

; free the original block (note that bseg and bheapblk are already on the
; stack in the proper order)

	callcrt _bfree

	add	sp,4			; clean off args to _bfree
	pop	ax			; ax = offset pointer to new block + 2
	jmp	short done

; Special case handling mandated by ANSI.

do_bmalloc:
	push	cx			; push newsize arg
	push	ax			; push bseg arg

	callcrt _bmalloc

	add	sp,4			; clean up stack
	jmp	short done

; Special case handling mandated by ANSI.

do_bfree:
	push	si			; push bheapblk arg
	push	ax			; push bseg arg

	callcrt _bfree

	add	sp,4			; clean up stack
	jmp	short ret_null

; failure
; Resizing and allocating have both failed. Restore the block to its original
; size and return NULL.

failure:
	call	_resize 		; restore original block size

ret_null:
	mov	ax,_NULLOFF
	mov	dx,bseg 		; return bseg:_NULLOFF for failure

done:
cEnd	<nolocals>

sEnd	code
	end
