	page	,132
	title	breset - Reset the rover pointer of a based heap segment
;***
;breset.asm - reset the rover of a based heap segment
;
;	Copyright (c) 1989-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _bheap_reset() - reset the rover pointer of a based heap
;	segment to the first allocation block.
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _bheap 			; based heap linked list descriptor

sEnd	data

externNP _findseg			; find a heap segment


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;int _bheap_reset(bseg) - reset rover in based heaps segment to first
;	allocation block
;
;Purpose:
;	Resets the rover in the supplied based heap segment to the first
;	allocation block. This is accomplished by first looking up the
;	heap segment descriptor, then copying the start field into the rover
;	field.
;
;	[MTHREAD NOTE: There is no support for multi-thread!]
;
;Entry:
;	unsigned bseg = based heap segment
;
;Exit:
;	Returns:
;		 0, if the rover pointer is successfully reset
;		-1, if an error occurs (i.e., the based heap segment is not
;		    not found)
;
;Uses:
;	ax,bx,es
;
;Exceptions:
;
;*******************************************************************************

cProc	_bheap_reset,<PUBLIC>,<>

	parmW	bseg		; based heap segment

cBegin


; Find the based heap descriptor for this segment
; es:si = block to free up

	mov	bx,dataoffset _bheap ; ds:bx = based heap header
	mov	ax,[bseg]	; ax = segment to find
	push	ds		; save dgroup
	call	_findseg	; go find it
	push	ds
	pop	es		; es:bx = heap descriptor (if bseg was valid)
	pop	ds		; restore dgroup
	jc	reset_err	; error, just return
	;fall thru

; Found the based heap descriptor that goes with the freed block
; es:bx = heap descriptor

	mov	ax,es:[bx].start  ; copy start into...
	mov	es:[bx].rover,ax  ; ...rover
	xor	ax,ax		  ; return 0 to indicate success
	jmp	short reset_done

reset_err:
	or	ax,-1		; return -1 to indicate failure

reset_done:			; return

cEnd	<nolocals>

sEnd	code

	end
