
	page	,132
	title	calloc -- Allocate array storage on the heap
;***
;calloc.asm - Allocate array storage on the heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;
;	This source builds three different objects corresponding to
;	the following three functions:
;
;		calloc	 - Allocate storage on the default heap
;		_ncalloc - Allocate storage on the NEAR heap
;		_fcalloc - Allocate storage on the FAR heap
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

;
; heapDPTR = size of pointer returned from heap call.
; _MALLOC_ = text string holding name of appropriate malloc routine
; _CALLOC_ = text string holding name of appropriate calloc routine
;

ifdef	_NEARHEAP
    heapDPTR = 0			; near heap
    ifdef   _LOAD_DGROUP
	externFP _dll_nmalloc		; near heap, CRTDLL flavor
	_MALLOC_ EQU <_dll_nmalloc>
	_CALLOC_ EQU <_dll_ncalloc>
    else
	externP _nmalloc		; near heap
	_MALLOC_ EQU <_nmalloc>
	_CALLOC_ EQU <_ncalloc>
    endif   ;_LOAD_DGROUP
else
    ifdef   _FARHEAP
	heapDPTR = 1			; far heap
	externP _fmalloc
	_MALLOC_ EQU <_fmalloc>
	_CALLOC_ EQU <_fcalloc>
    else
	heapDPTR = sizeD		; default heap
	externP malloc
	_MALLOC_ EQU <malloc>
	_CALLOC_ EQU <calloc>
    endif
endif


sBegin	code
	assumes ds,data
	assumes cs,code


page
;***
;calloc(), _ncalloc(), _fcalloc() - Allocate array storage on heap
;
;Purpose:
;	Allocate array storage on the heap.  Each element of the
;	allocate array is initialized to 0.
;
;Entry:
;	unsigned nelem	 = number of elements
;	unsigned elsize  = size of each element
;
;	[DLL NOTE: On entry ds:bx = near heap descriptor.]
;
;Exit:
;	void [near/far] * = success = pointer to allocated memory
;			    failure = NULL (insufficient memory)
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

% cProc   _CALLOC_,<PUBLIC>,<di>

	parmW	nelem		; number of array elements
	parmW	elsize		; element size

cBegin

ifdef	_LOAD_DGROUP
;	[DLL NOTE: On entry ds:bx = near heap descriptor.
;	This must preserved through to the __dll_nmalloc call.]
endif

;
; Calculate how big a chunk of memory to get
;

	mov	ax,[nelem]	; number of elements
	mul	[elsize]	; dx:ax = <nelem> * <elsize>
	jnc	get_array	; if < 64k, continue
	;fall thru		; product > 64k, error

;
; Error return
;
	xor	ax,ax		; return NULL
	cwd
	jmp	short done

;
; Call malloc() to get the memory
; ax = size of array
;

get_array:
	push	ax		; size on stack
	call	_MALLOC_	; get the memory from the heap
	pop	cx		; cx = requested size

if heapDPTR
	mov	bx,ax
	or	bx,dx		; dx:ax == NULL ??
else
	or	ax,ax		; ax = NULL ??
endif
	jz	done		; yes, return error

;
; Fill the newly allocated block with zeros
; [dx:]ax = address of block
; cx = byte size
;

	push	ax		; preserve ax
	mov	di,ax		; di = address offset
if heapDPTR
	mov	es,dx		; es:di = address
else
	mov	ax,ds
	mov	es,ax		; es:di = address
endif
	xor	ax,ax		; ax = 0 = fill value / cx = count
	inc	cx		; cx = an even word count
	shr	cx,1
	rep	stosw		; zero the array
	pop	ax		; restore [dx:]ax
	;fall thru

;
; Common return
; [dx:]ax = return value
;

done:

cEnd	<nolocals>

sEnd	code

	end
