/***
*delete.cxx - defines C++ delete routines
*
*	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Defines delete routines
*
*******************************************************************************/

#include <internal.h>
#include <malloc.h>
#include <new.h>

#if ((!defined _NEAR_NEW_) && (!defined _FAR_NEW_) && (!defined _HUGE_NEW_) && (!defined _BASED_NEW_))
#error No memory model defined.
#endif

#ifdef	_NEAR_NEW_
    void operator delete( void _near * np )
    {
	_nfree( np );
    }
#endif	// _NEAR_NEW_


#ifdef	_FAR_NEW_
    void operator delete( void _far * lp )
    {
	_ffree( lp );
    }
#endif	// _FAR_NEW_


#ifdef	_HUGE_NEW_
    void operator delete( void _huge * hp )
    {
	_hfree( hp );
    }
#endif	// _HUGE_NEW_


#ifdef	_BASED_NEW_
    void operator delete( _segment sb, void _based(void) * ib )
    {
	_bfree( sb, ib );
    }
#endif	// _BASED_NEW
