	page	,132
	title	dllheap -- DLL heap stub routines
;***
;dllheap.asm - DLL heap stub routines
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Contains the CRTDLL heap stub routines.
;
;	DLL front end stub for near heap routines.  In the DLL, we
;	want to operate on the caller's DGROUP, not the library's
;	DGROUP.  Thus, we need to pass the near heap descriptor address
;	(__nheap_desc) in to the dll routine.
;
;*******************************************************************************

.286p

.xlist
include version.inc
include cmacros.inc
.list

sBegin	data
assumes ds,data

externW _nheap_desc		; Near heap descriptor

sEnd	data

extrn	__dll_heapadd:far	; DLL routines
extrn	__dll_ncalloc:far
extrn	__dll_nexpand:far
extrn	__dll_nfreect:far
extrn	__dll_nfree:far
extrn	__dll_nheapchk:far
extrn	__dll_nheapmin:far
extrn	__dll_nheapset:far
extrn	__dll_nheapwalk:far
extrn	__dll_nmalloc:far
extrn	__dll_nmemavl:far
extrn	__dll_nmemmax:far
extrn	__dll_nrealloc:far

sBegin	code
assumes ds,data
assumes cs,code


; Locations containing the dll routine address
; (put in code segment so it's read only memory)

dll_heapadd	dd	__dll_heapadd
dll_ncalloc	dd	__dll_ncalloc
dll_nexpand	dd	__dll_nexpand
dll_nfreect	dd	__dll_nfreect
dll_nfree	dd	__dll_nfree
dll_nheapchk	dd	__dll_nheapchk
dll_nheapmin	dd	__dll_nheapmin
dll_nheapset	dd	__dll_nheapset
dll_nheapwalk	dd	__dll_nheapwalk
dll_nmalloc	dd	__dll_nmalloc
dll_nmemavl	dd	__dll_nmemavl
dll_nmemmax	dd	__dll_nmemmax
dll_nrealloc	dd	__dll_nrealloc


page
;*******************************************************************************

cProc	_heapadd,<PUBLIC>,<si>

	parmD	block		; far pointer to block of memory
	parmW	blocksize	; size of block
	localW	popstk		; number of bytes to pop off stack

cBegin
	push	[blocksize]	; pass along args
	push	word ptr [block+2]
	push	word ptr [block]
	mov	ax,6		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_heapadd
	jmp    short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

cProc	_ncalloc,<PUBLIC>,<si>

	parmW	nelem		; number of array elements
	parmW	elsize		; element size
	localW	popstk		; number of bytes to pop off stack

cBegin
	push	[elsize]	; pass args along
	push	[nelem]
	mov	ax,4		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_ncalloc
	jmp    short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

cProc	_nheapchk,<PUBLIC>,<si>

	localW	popstk		; number of bytes to pop off stack

cBegin
	xor	ax,ax		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_nheapchk
	jmp    short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

cProc	_nheapset,<PUBLIC>,<si>

	parmW	setval		; unsigned int heap set value
	localW	popstk		; number of bytes to pop off stack

cBegin
	push	[setval]	; heap set value
	mov	ax,2		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_nheapset
	jmp    short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

cProc	_nheapwalk,<PUBLIC>,<si>

	parmDP	address 	; address of _heapinfo struct
	localW	popstk		; number of bytes to pop off stack

cBegin
	push	word ptr [address+2]	 ; address of _heapinfo struct
	push	word ptr [address]
	mov	ax,4		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_nheapwalk
	jmp    short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

cProc	_nfree,<PUBLIC>,<si>

	parmW	address 	; address of block to be freed
	localW	popstk		; number of bytes to pop off stack

cBegin
	push	[address]	; size of requested memory
	mov	ax,2		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_nfree
	jmp    short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

cProc	_nmalloc,<PUBLIC>,<si>

	parmW	incr		; unsigned int allocation size
	localW	popstk		; number of bytes to pop off stack

cBegin
	push	[incr]		; size of requested memory
	mov	ax,2		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_nmalloc
	;jmp	short call_dll	; join common dll calling code

;*******************************************************************************
;*******************************************************************************

;
; Common code to call the dll routines
; (in middle of code so all routines can jump short)
; si = code offset of dll routine
; ax = number of bytes to be popped off stack after call
;

call_dll:
	mov	[popstk],ax			; save # bytes to pop off stack
	mov	bx,dataoffset _nheap_desc	; ds:bx = heap desc
	call	dword ptr cs:[si]		; call the dll routine
	add	sp,[popstk]			; clean off stack

cEnd

;*******************************************************************************
;*******************************************************************************

cProc	_nexpand,<PUBLIC>,<si>

	parmW	nheapblk		; pointer to near heap block
	parmW	newsize 		; desired new size
	localW	popstk			; number of bytes to pop off stack

cBegin
	push	[newsize]		; pass args along
	push	[nheapblk]
	mov	ax,4			; ax = # of bytes to pop off stack
	mov	si,codeOFFSET dll_nexpand
	jmp	short call_dll		; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

cProc	_nheapmin,<PUBLIC>,<si>

	localW	popstk			; number of bytes to pop off stack

cBegin
	xor	ax,ax			; ax = # of bytes to pop off stack
	mov	si,codeOFFSET dll_nheapmin
	jmp	short call_dll		; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

cProc	_nrealloc,<PUBLIC>,<si>

	parmW	nheapblk		; pointer to near heap block
	parmW	newsize 		; desired new size
	localW	popstk			; number of bytes to pop off stack

cBegin
	push	[newsize]		; pass args along
	push	[nheapblk]
	mov	ax,4			; ax = # of bytes to pop off stack
	mov	si,codeOFFSET dll_nrealloc
	jmp	short call_dll		; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

labelP	<PUBLIC,_freect>

cProc	_nfreect,<PUBLIC>,<si>

	parmW	itemsize	; size of item
	localW	popstk		; number of bytes to pop off stack

cBegin
	push	[itemsize]	; pass on size of item
	mov	ax,2		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_nfreect
	jmp	short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

labelP	<PUBLIC,_memavl>

cProc	_nmemavl,<PUBLIC>,<si>

	localW	popstk		; number of bytes to pop off stack

cBegin
	xor	ax,ax		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_nmemavl
	jmp	short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

labelP	<PUBLIC,_memmax>

cProc	_nmemmax,<PUBLIC>,<si>

	localW	popstk		; number of bytes to pop off stack

cBegin
	xor	ax,ax		; ax = # of bytes to pop off stack
	mov	si,codeoffset dll_nmemmax
	jmp	short call_dll	; join common dll calling code

cEnd	<nogen>

;*******************************************************************************

sEnd	code

	end
