	page	,132
	title	halloc - C Run-time huge heap allocation
;***
;halloc.asm - C runtime huge heap allocation
;
;	Copyright (c) 1986-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines halloc() and hfree() - huge array allocation, deallocation
;
;*******************************************************************************

include version.inc

.xlist
include cmacros.inc
include msdos.inc
.list

sBegin	DATA
assumes DS,DATA

externW _aseghi 	    ; highest segment so far
externW _aseglo 	    ; smallest allowable segment

ifndef	_NOTCXX_
globalCP  _pnhhHugeHeap, 0
endif

sEnd  DATA

	page

sBegin	CODE
assumes CS,CODE
assumes DS,DATA

page
;***
;int _hfree(address) - deallocate huge array
;
;Purpose:
;	frees the memory used by a huge array allocated with halloc() and
;	returns it to DOS.
;
;Entry:
;	huge *address - address of block to free
;
;Exit:
;	returns any error status in AX
;
;Uses:
;	ES
;
;Exceptions:
;
;*******************************************************************************

cProc	_hfree,<PUBLIC>
	parmD	address
cBegin
	mov	es,Word Ptr (address+2)
	callos	freemem
cEnd	nolocals

page
;***
;HUGE *_halloc(cnumber, cbsize) - allocate huge array
;
;Purpose:
;	allocates a huge a huge array from DOS.  If the array size
;	is >128KB, the the size of each array element must be a power
;	of 2.
;
;Entry:
;	long cnumber - number of elements in array
;	int cbsize - number of bytes per element
;
;Exit:
;	DX:AX - segment address of array start or 0:0 in case of error.
;
;Uses:
;	BX, CX
;
;Exceptions:
;
;*******************************************************************************

cProc	_halloc,<PUBLIC>,<si,di>
	parmD	cnumber 	; Number of objects
	parmW	cbsize		; Size of objects in bytes
cBegin
ifndef	_NOTCXX_
RetryHalloc:
endif
	mov	bx,cbsize
	mov	ax,word ptr (cnumber)
	mul	bx
	mov	cx,ax		; low word of allocation size
	mov	di,dx		; partial high word of ...

	mov	ax,word ptr (cnumber+2)
	mul	bx
	add	ax,di		; high word of allocation size
	mov	dx,ax

	or	ax,cx		; test for 0-length allocation
	jz	_ret_zero

	xor	si,si		; offset to be returned
;
; In general, to clear the least significant `1' bit in a number "x",
; do a bit-wise AND of "x" with "x"-1.	To check if "x" is a power of 2,
; do this bit-wise AND of "x" and "x"-1, and check for a zero result,
; since a power of 2 has only a single `1' bit.  This trick is used in
; two places in the following code, and in both places it is known that
; "x" is non-zero.  (The trick presumes that "x" is non-zero.)
;
	lea	ax,[bx-1]	; AX = cbsize - 1
;
;	DX:CX is the allocation size
;	BX is "cbsize"
;	AX is "cbsize"-1
;	DI is scratch
;	SI is the offset to be returned (usually 0)
;
not_zero:
;
;	DX:CX must be less than 1 Megabyte!
;	In fact, it must be less than 1 Megabyte - 15 bytes
;	since DX:CX will be rounded up to a multiple of 16.
;
	cmp	dx,0FH
	ja	_ret_zero	; cannot allocate >= 1 MB
	jb	lt_1_MB
	cmp	cx,0FFF0H	; 0F:FFF0H = 1 MB less 16 bytes
	ja	_ret_zero
lt_1_MB:
	cmp	dx,2
	ja	more_than_128K	; Size is > 128 KB
	jb	less_equal_128K ; Size is < 128 Kbytes

	jcxz	less_equal_128K ; Size is = 128 Kbytes
;
; If the HUGE allocation is greater than 128 Kbytes,
; the array element size must be a power of two.
; "cbsize" must one of [1,2,4,8,...,16384,32768]
;
more_than_128K:
	and	ax,bx		; is "cbsize" a power of 2?
	jz	round_to_para	; see above for explanation of this trick
	;fall thru to 'ret_zero'

;
; --- Bridge to 'ret_zero' ---
;
_ret_zero:
	jmp	short ret_zero

;
; For allocations between 64K+1 and 128K (inclusive),
; the last item in the first segment must end on the
; segment boundary.  This is done by starting the
; first element at offset (65536L % cbsize).
; If "cbsize" is a power of 2, the offset will be 0.
;
less_equal_128K:
	cmp	dx,1		; allocation < 64k ?
	jb	round_to_para

	and	ax,bx		; is "cbsize" a power of 2 ?
	jz	round_to_para	; see above for explanation of this trick

	xor	ax,ax		; no, DX:AX = 1:0 = 65536L
	div	bx		; dx = (65536 % cbsize)
	mov	si,dx		; save return offset
	add	cx,dx		; bump size of request by remainder
	jc	ret_zero	; addition caused request to be > 128k and
				;    cbsize is not a power of two...
	mov	dx,1		; restore dx to original value
;
; Allocate the huge block (DOS expects a paragraph size)
;
round_to_para:
	mov	bx,cx		; DX:BX = allocation size
	add	bx,15		; Round value to nearest paragraph
	adc	dx,0		; 32 bit addition being done
	mov	cx,4		; right-shift by 4 bits
shift_loop:
	shr	dx,1
	rcr	bx,1
	loop	shift_loop

memcall:			; allocate the memory
	callos	allocmem	; BX == # of paragraphs requested
	jc	ret_zero	; Unable to allocate memory, return NULL

;
; Set _aseghi/_aseglo if appropriate
; ax = base huge segment, bx = # of paragraphs
;
	cmp	ax,[_aseglo]	; new seg > _aseglo ??
	jbe	memcall 	; no, try it again

	mov	dx,ax		; preserve ax
	add	dx,bx		; add # of paragraphs
	dec	dx		; dx = selector for last valid paragraph
	cmp	dx,[_aseghi]	; new seg > _aseghi ??
	jbe	set_es		; nope, continue
	mov	[_aseghi],dx	; yes, update _aseghi
set_es:
	mov	es,ax		; ES = base selector of new memory
	mov	dx,ax		; DX:SI = starting address
	cld			; Must be in UP direction
	mov	cx,1000H
;
; Allocated memory must be initialized to zero, 64KB at a time
;
; DX:AX = return value (AX is saved in SI in part of the loop)
; ES = current segment
; BX = count of paragraphs remaining to be cleared
; DI and CX are used by the REP STOSW instruction
;
zeromem:
	cmp	bx,cx		; Still at least a 64K chunk left?
	jae	clrblk		; Yes, proceed
	mov	cx,bx		; Final block is not a full 64KB
clrblk:
	shl	cx,1		; Convert paragraphs to words
	shl	cx,1
	shl	cx,1
	xor	di,di		; Always zero based clear operation
	xor	ax,ax
	rep	stosw		; Clear chunk of memory

	xchg	ax,si		; DX:AX = return value
	mov	cx,1000H	; 4096 paragraphs in 65,536 bytes
	sub	bx,cx		; Update count of paragraphs remaining
	jbe	ret_okay	; Cycle for next 64KB block of memory

	xchg	ax,si		; DX:SI = return value
	mov	ax,es
	add	ax,cx
	mov	es,ax		; advance ES to next 64KB segment
	jmp	short zeromem


ret_zero:			; DX:AX == pointer = 0L, indicating an error
	xor	ax,ax
	cwd

ifndef	_NOTCXX_
if  sizeC
	mov	cx, word ptr [_pnhhHugeHeap+2]
	or	cx, word ptr [_pnhhHugeHeap]
	jz	ret_okay
else	;not sizeC
	cmp	[_pnhhHugeHeap], ax	; ax = 0.
	je	ret_okay
endif	;not sizeC

	push	word ptr [cnumber+2]
	push	word ptr [cnumber]
	push	[cbsize]
	call	[_pnhhHugeHeap]
	add	sp, 6
	cwd			; Set dx:ax = NULL, if ax = 0.
	or	ax, ax
	jz	ret_okay	; if ax = 0, then return.

	jmp	RetryHalloc
endif	;not _NOTCXX_

ret_okay:			; Return with DX:AX == pointer

cEnd	nolocals

sEnd	CODE

	end
