	page	,132
	title	fdata - Far heap data
;***
; fdata.asm - Far heap data
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains data used by the far heap.
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

; --- Far heap linked list header ---

labelW	<PUBLIC,_fheap> 	; far heap link descriptor
	_heap_list_desc <0,0,0,_HEAP_MODIFY OR _HEAP_FREE>

sEnd	data


ifdef _WINDLL

externNP _freelist			; free up a heap list

sBegin	code
	assumes cs,code
	assumes ds,nothing

page
;***
; _freefarheap - Free all far heap memory to OS
;
;Purpose:
;	This routine frees all far heap memory to the OS.
;
;	[It is currently used in _WINDLL models because
;	GlobalMemory is not automatically reclaimed by Windows
;	if it is shared (which the Win DLL lib memory is).
;
;Entry: void
;
;Exit:	void
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_freefarheap,<PUBLIC,NEAR>,<>

cBegin	<nolocals>

	mov	bx,dataoffset _fheap
	push	ds
	pop	es			; es:bx = far heap list header
	call	_freelist		; free up all far heap memory

cEnd <nolocals>

sEnd	code

endif	;_WINDLL


	end
