	page	,132
	title	fexpand - C runtime far heap expand
;***
;fexpand.asm - far heap block expansion
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _fexpand() - expand (contract) a block in the far heap.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _fheap 		; near heap segment descriptor

sEnd	data


externNP _resize
externNP _findseg

sBegin	code
	assumes cs,code
	assumes ds,data

;***
;_fexpand(void far *fheapblk, size_t newsize) - expand (contract) a block
; in the far heap
;
;Purpose:
;	Expand (contract) the specified block in the far heap to newsize. If
;	the block is successfully resized, fheapblk is returned. If not
;	successful, the block is expanded as much as possible and NULL is
;	returned. If an error occurs, NULL is returned and errno is set to
;	*** E_?????? ***.
;
;	_fmsize can be used to determine the new size
;
;	_fexpand does not change the free/inuse status of the block
;
;Entry:
;	void far *fheapblk  - pointer to far heap block to be expanded + 2
;	size_t newsize	    - new size for block
;
;Exit:
;	returns fheapblk if successful
;	returns NULL if not successful
;	errno set to *** E_?????? *** if an error occurs
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

cProc	_fexpand,<PUBLIC>,<si,di>


	parmD	fheapblk
	parmW	newsize

cBegin
	mov	bx,dataOFFSET _fheap
	mov	ax,word ptr [fheapblk+2]
	push	ds			; save DGROUP for return
	assumes ds,nothing
	call	_findseg		; _findseg preserves es and si
	jc	bad_ret
	mov	si,word ptr [fheapblk]
	push	si
	mov	cx,[newsize]
	call	_resize
	pop	ax
	mov	dx,ds			; dx:ax == fheapblk
	pop	ds			; restore DGROUP
	jc	bad_ret1
	jmp	short good_ret
bad_ret:
;	*** SHOULD ERRNO BE SET TO E_?????? HERE? ***
	pop	ds			; restore DGROUP
bad_ret1:
	xor	ax,ax			; return far NULL
	cwd
good_ret:
cEnd	<nolocals>

sEnd	code
	end
