	page	,132
	title	fheapchk -- Check the far heap
;***
;fheapchk.asm - Check the far heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Check the far heap.
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list


sBegin	data
	assumes ds,data

externW  _fheap 			; far heap linked list header

sEnd	data

externNP _setlist			; check a linked list of heap segs


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;int _fheapchk(void) - Miminal validity check on the far heap
;
;Purpose:
;	Perform a minimal consistency check on the far heap.
;
;Entry:
;	<none>
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPOK 	 - completed okay
;	_HEAPEMPTY	 - far heap not initialized
;	_HEAPBADBEGIN	 - can't find initial header info
;	_HEAPBADNODE	 - malformed node somewhere
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

if	sizeD
labelP	<PUBLIC,_heapchk>
endif

cProc	_fheapchk,<PUBLIC>,<si,di>

cBegin

	mov	cx,_HEAPSET_NOFILL	; cx = don't fill the free blocks
	;fall through

;
; Both _fheapchk and _fheapset enter here.
; cx = fill value or _HEAPSET_NOFILL
;

common:


	mov	di,dataoffset _fheap	; ds:di = far heap header
	call	_setlist		; check it out


cEnd	<nolocals>


page
;***
;int _fheapset(unsigned) - Set contents of free far heap blocks
;
;Purpose:
;	Fill all the free blocks in the far heap with the
;	supplied value.  Also, perform some heap consistency
;	checks while we're at it.
;
;Entry:
;	unsigned = fill value
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPOK 	 - completed okay
;	_HEAPEMPTY	 - far heap not initialized
;	_HEAPBADBEGIN	 - can't find initial header info
;	_HEAPBADNODE	 - malformed node somewhere
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

if	sizeD
labelP	<PUBLIC,_heapset>
endif

cProc	_fheapset,<PUBLIC>,<si,di>

	parmW	fill			; fill value

cBegin

	mov	cx,[fill]		; cx = fill value
	jmp	short common		; join _fheapchk

cEnd	<nogen>

sEnd	code

	end
