	page	,132
	title	fheapmin - Minimize the far heap

;***
;fheapmin.asm - Minimize the far heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Contains _fheapmin, the function that minimizes the far heap segments.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _fheap				; based heap list descriptor

sEnd	data


externNP _searchseg			; coalesce free blocks
externNP _minseg			; minimize a heap segment

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;int _fheapmin(void) - Minimize the far heap.
;
;Purpose:
;	Walk the list of segments in the far heap and 'minimize' each one.
;	For each segment in the far heap, use _searchseg to coalesce the free
;	blocks and, then, use _minseg to shrink the segment (releasing unused
;	memory at the end of the segment back to the OS) or free it if
;	possible.
;
;Entry:
;
;Exit:
;	return value =	0, if no error has occurred
;		     = -1, if an error has occurred (in this case, errno
;			   will have been set by one of the helper routines)
;
;Uses:
;	everything except si, di, ds (which are explicitly saved and restored)
;
;Preserves:
;	si, di, ds
;
;Notes:
;	A far heap segment is freed (i.e., unlinked from the far heap list
;	and released back to the OS) by _fminseg iff it consists of exactly
;	one free allocation block and the _HEAP_MODIFY and _HEAP_FREE flags
;	are set in the descriptor. These conditions are determined in the
;	_minseg routine (see minseg.asm).
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

if	sizeD
labelP	<PUBLIC,_heapmin>
endif

cProc	_fheapmin,<PUBLIC>,<>


cBegin	<nogen>

	push	si			; save caller's si
	push	di			; save caller's di
	push	ds			; save caller's ds

; Walk the list of far heap segments. For each segment, coalesce the free
; blocks and 'minimize' the segment.

	push	ds
	pop	es
	mov	di,dataOFFSET _fheap	; es:di = pointer to _fheap
	lds	bx,_fheap.startseg	; get first far heap seg
	assumes ds,nothing

minimize:
	mov	cx,ds
	jcxz	good_ret		; empty list, we're done
	mov	cx,_HEAP_COALESCE
	push	es
	push	di			; save es:di across call
	call	_searchseg		; coalesce the segment amap
	pop	di
	pop	es			; es:di = pointer to _fheap (again)
	push	word ptr ds:[bx].nextseg+2 ; push far pointer to next heap
	push	word ptr ds:[bx].nextseg   ; segment descriptor onto stack
	push	es
	push	di			; save es:di across call
	call	_minseg
	pop	di
	pop	es			; es:di = pointer to _fheap (again)
	pop	bx
	pop	ds			; ds:bx = ptr to next heap seg desc
	jc	error_ret		; error!
	jmp	short minimize

error_ret:
	mov	ax,-1			; return -1 to indicate error
	jmp	short done

good_ret:
	xor	ax,ax			; return 0 to indicate success

done:
	pop	ds			; restore caller's ds
	pop	di			; restore caller's di
	pop	si			; restore caller's si
	ret

cEnd	<nogen>

sEnd	code
	end
