	page	,132
	title	fheapwalk -- Walk the far heap
;***
;fheapwalk.asm - Walk the far heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list


sBegin	data
	assumes ds,data

externW  _fheap 			; far heap linked list header

sEnd	data

externNP _walklist			; walk a linked list of heap segs


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;int _fheapwalk(&_heapinfo) - Walk the far heap
;
;Purpose:
;	Get the next far heap entry (along with size and used/free
;	status).  If _heapinfo._pentry == NULL, return information
;	about the first entry in the heap.
;
;Entry:
;	&_heapinfo = address of a _heapinfo structure (possibly returned
;		by a previous call to _fheapwalk).  The contents are:
;
;		_pentry = far pointer to heap entry (could be NULL)
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPEMPTY	- far heap not initialized
;	_HEAPBADBEGIN	- can't find initial header info
;	_HEAPBADNODE	- malformed node somewhere
;	_HEAPOK 	- heap ok
;	_HEAPEND	- end of heap reached
;
;	Fills in the _heapinfo structure as follows:
;
;		_pentry = far pointer to heap entry
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

if	sizeD
labelP	<PUBLIC,_heapwalk>
endif


;--- Single thread version
cProc	_fheapwalk,<PUBLIC>,<si,di>


	parmDP	address 		; address of _heapinfo struct

cBegin

; Get far heap header and _heapinfo address

	mov	bx,dataoffset _fheap	    ; ds:bx = far heap header

if	sizeD
	les	di,[address]		; es:di = address of heapinfo struct
else
	mov	di,[address]		; es:di = address of heapinfo struct
	mov	ax,ds
	mov	es,ax
endif

; Call _walklist to do all the work
; ds:bx = far heap header
; es:di = heapinfo address

	call	_walklist

; Return the result of _walklist
; ax = return value

done:

cEnd	<nolocals>

sEnd	code

	end
