	page	,132
	title	findseg - Find the descriptor of a heap segment

;***
;findseg.asm - Find the descriptor of a heap segment.
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Find the heap segment descriptor corresponding to the given heap
;	segment.
;
;******************************************************************************

.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,nothing

page
;***
; _findseg - Find the heap segment descriptor corresponding to the given heap
; segment.
;
;Purpose:
;	Walk the given heap segment list looking for the heap segment
;	desciptor corresponding to the given segment selector.
;
;Entry:
;	ds:bx = pointer to heap segment list descriptor
;	ax = selector of the heap segment to find
;
;Exit:
;	Success:
;		carry = clear
;		ds:bx = pointer to heap segment descriptor
;	Failure:
;		carry = set
;		ds:bx unchanged
;
;Uses:
;	ax, cx
;
;Preserves:
;	dx, si, di, es
;******************************************************************************

cProc	_findseg,<PUBLIC,NEAR>,<>

cBegin	<nogen>

; make sure segment !0

	or	ax,ax			; is seg 0 ??
	jz	failure2		; yes, error

; first check if roverseg is the one we want

	cmp	ax,word ptr [bx].roverseg + 2
	jne	start_walk
	lds	bx,[bx].roverseg	; roverseg is it, set up return
	jmp	short good_ret

; start_walk
; Setup to walk the list of heap segments, from startseg to lastseg

start_walk:
	push	ds			; may need for error return
	push	bx			; may need for error return
	lds	bx,[bx].startseg
	jmp	short walk_list1	; jump over re-init part of loop

; failure
; Restore ds:bx, set carry, and return

failure:
	pop	bx			; restore ds:bx
	pop	ds
failure2:
	stc				; carry set = error
	jmp	short done

; walk_list
; Walk the heap segment list until we hit the end (next heap segment selector
; is 0) or find the segment whose selector matches the one in ax.

walk_list:
	lds	bx,[bx].nextseg 	; reinitialization of loop

walk_list1:
	mov	cx,ds
	jcxz	failure 		; segment selector = 0?
	cmp	ax,cx			; does the selector match?
	jne	walk_list		; no, go try the next segment

	add	sp,4			; clean up stack

good_ret:
	clc				; carry clear = success
;
; Common return
;

done:
	ret

cEnd	<nogen>

sEnd	code

	end
