	page	,132
	title	fmalloc -- C runtime far heap allocation
;***
;fmalloc.asm - far heap allocation
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _ffree(), _fmalloc() - allocate/free memory from the
;	far heap.
;
;*******************************************************************************


.xlist
include	version.inc
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _fheap 			; far heap linked list descriptor

ifndef	_NOTCXX_
globalCP _pnhFarHeap, 0
endif

sEnd	data

externNP _growseg			; grow a heap segment
externNP _searchseg			; search a heap segment
externNP _newseg			; get a new heap segment


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;void _ffree(ptr) - free block in the far heap
;
;Purpose:
;	Free a block of memory in the far heap which was allocated
;	by _fmalloc().
;
;	[NOTE: This code assumes that fmalloc() does NOT allocate
;	memory from the near heap.]
;
;	[MTHREAD NOTE: Since the freeing of a heap entry is an
;	atomic action, the heap lock is not needed.  Note that if
;	the RESET_ROVER code is implemented, _ffree() must lock/unlock
;	the heap.]
;
;Entry:
;	void far *ptr - pointer to block to free
;
;Exit:
;	<none>
;Uses:
;	ax,bx,cx,dx,es
;
;Exceptions:
;
;*******************************************************************************


cProc	_ffree,<PUBLIC>,<si>

	parmD	address

cBegin

; Get address and make sure it's not NULL

	les	si,[address]	; es:si = address
	mov	cx,es		; is address == NULL ??
	jcxz	  _ffend	; yup - just return


	or	byte ptr es:[si-2],1 ; free entry


_ffend: 			; return

cEnd	<nolocals>

page
;***
;void far *_fmalloc(size) - allocate a memory block in the far heap
;
;Purpose:
;	Allocates a memory block of at least size bytes in the far heap.
;	The block will be aligned for the storage of any type of object.
;
;Entry:
;	unsigned size - size of memory block desired
;
;Exit:
;	dx:ax = success = address of block
;	      = failure = NULL
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************



;--- Single thread version
cProc	_fmalloc,<PUBLIC>,<si,di>


	parmW	incr		; unsigned int allocation size

cBegin

ifndef _NOTCXX_
RetryFMalloc:
endif

;
; Make sure the requested size is not too big
;

	mov	cx,[incr]	; cx = request block size
	cmp	cx,_HEAP_MAXREQ ; cx > maximum legal request size ??
	ja	error_rtn	; nope, try to get the memory

;
; See if far heap is initialized
;
	push	ds			; save dgroup on stack
	mov	ax,word ptr [_fheap].startseg+2 ; get first far heap segment
	or	ax,ax			; is it NULL ??
	jz	new_seg 		; yes, jump over search
	;fall thru

;
; --- Walk the heap segment list ---
; The walk_list loop below is executed up to four times. Twice to try to find
; a heap block of suitable size and, if necessary, twice more to try to grow
; one of the heap segments to accomodate a heap block of suitable size. The
; following is lists the 4 possible heap walks:
;
;	(1) SEARCH: Walk the heap segment searching for a free block big enough:
;		(a) roverseg -> lastseg
;		(b) startseg -> roverseg - 1
;	(2) GROW: Walk the heap segment trying to grow a segment to fullfill request:
;		(a) roverseg -> lastseg
;		(b) startseg -> roverseg - 1

; --- Part 1: Search the segments for a free block ---

	mov	di,codeOFFSET _searchseg	; di = routine pointer

	; set up for search from roverseg -> lastseg
walk_rover:
	mov	si,word ptr [_fheap].lastseg+2	; si = end of search segment
	lds	bx,[_fheap].roverseg		; ds:bx = start of search
	assumes ds,nothing

;
; --- Walk the list of segments ---
;
; cx	= size
; ds:bx = start-of-search heap descriptor
; si	= end-of-search heap segment
; di	= pointer to walk function (either _searchseg or _growseg)
; tos	= dgroup
;

walk_list:
	push	ds		; save start-of-search segment
walk_next:
	push	si		; save end-of-search pointer
	push	di		; save function pointer
	call	di		; call _searchseg/_growseg
	pop	di
	pop	si
	jnc	walk_success	; success, go finish up
	mov	dx,ds		; save ds for compare
	lds	bx,ds:[bx].nextseg ; get pointer to next heap seg desc
	cmp	dx,si		; was segment just checked == end of search ??
	jne	walk_next	; nope, go try the next one
	; fall thru

	;*** OPTIONAL CONSISTENCY CHECK
	;mov	 dx,ds		 ; is the new nextseg == 0 ??
	;or	 dx,dx
	;jz	 _heap_toast	 ; ouch!
	;*** END CONSISTENCY CHECK ***

;
; --- End of walk list ---
;
; See if we need to walk list again, this time from startseg to rover-1.
;

	pop	ax			; get last start-of-search segment

	pop	ds			; restore ds to DGROUP
	assumes ds,data
	push	ds			; leave DGROUP on tos too
	les	si,ds:[_fheap].roverseg ; es:si = roverseg
	mov	si,word ptr es:[si].prevseg+2	; si = segment before rover
	lds	bx,ds:[_fheap].startseg ; ds:bx = starting segment
	assumes ds,nothing

	mov	dx,ds			; last start-of-search == startseg ??
	cmp	dx,ax
	jne	walk_list		; nope, walk from startseg -> roverseg-1
	;fall thru			; yes, try growing a segment

;
; --- Part 2: Try to grow a segment ---
; Check to see if we have tried to grow segments yet.  If not, do it.
;

	;*** REAL MODE - NORMALLY WE WILL ONLY BE ALBE TO GROW THE
	;*** LAST HEAP SEGMENT.  SO WE MAY WANT TO ONLY GROW THAT
	;*** SEGMENT AND, IF FAILURE, IMMEDIATELY TRY FOR A NEW SEGMENT.

try_grow:
	pop	ds			; restore ds to DGROUP
	assumes ds,data
	push	ds			; leave DGROUP on tos too
	cmp	di,codeOFFSET _growseg	; have we been calling _growseg ??
	je	new_seg 		; yup, try to get a new segment

	mov	di,codeOFFSET _growseg	; di = pointer to _growseg
	assumes ds,nothing
	jmp	short walk_rover	; go start the heap walk with roverseg

; --- Walk list success --
; The walk_list loop has exited with 'success'. Check whether it found a heap
; block or grew a heap segment, and branch accordingly.

walk_success:
	pop	si			; clean off stack
	cmp	di,codeOFFSET _searchseg
	je	found_block		; a heap_block was found
	jmp	short grow_worked	; a heap segment was expanded

;
; --- Part 3: Get a new segment ---
; We did not find a block in our search nor were we able to grow a
; segment to fullfill our needs.  So, get a new segment and link
; it into the far heap.
; cx = size
; tos = dgroup
;

new_seg:
	pop	es		     ; es = dgroup
	push	es		     ; leave on stack
	mov	di,dataoffset _fheap ; es:di = heap list desc
	call	_newseg 	     ; get a new segment desc in ds:bx
	jc	error_rtn0	     ; error, nothing more we can do
	;fall thru		     ; sucess - ds:bx = heap desc / cx = size

;
; We grew or allocated a segment big enough to satisfy the user's request.
; Get the block out of this segment.
; cx = size
; ds:bx = far heap descriptor for the grown segment
; tos = dgroup
;

grow_worked:			; ds:bx = segment descriptor / cx = size
	call	_searchseg	; go search the segment

	;*** VALIDITY CHECK / OPTIONAL ***
	;jc	 _heap_toast	; *** internal consistency error ***

	;fall thru

;
; --- Found a block that satisfies our needs ---
; dx:ax = address of block
; ds:bx = far heap descriptor for that block
; tos = dgroup
; (ds = dx)
;

found_block:
	pop	ds		; restore ds = dgroup
	assumes ds,data
	mov	word ptr [_fheap].roverseg+2,dx  ; far heap rover = dx:bx
	mov	word ptr [_fheap].roverseg,bx
	jmp	short fdone	; All done

;
; Error return.  Whenever NULL is going to be returned, we end up here.
;

error_rtn0:
	pop	ds		; restore ds = dgroup
	assumes ds,data
error_rtn:

	xor	ax,ax		; dx:ax = NULL
	cwd

ifndef _NOTCXX_
if  sizeC
	mov	cx, word ptr (_pnhFarHeap+2)
	or	cx, word ptr (_pnhFarHeap)
	jz	fdone
else	;not sizeC
	cmp	(_pnhFarHeap), ax	; ax = 0.
	je	fdone
endif	;not sizeC

	push	[incr]
	call	(_pnhFarHeap)
	add	sp, 2

	cwd			    ; Set dx:ax to NULL if ax = 0.
	or	ax, ax
	jz	fdone		    ; if ax = 0, return NULL.

	jmp	RetryFMalloc
endif	;not _NOTCXX_

;
; Common exit
; (dx:ax = return value)
;

fdone:

cEnd	<nolocals>

sEnd	code

	end
