	page	,132
	title	fmsize - C runtime far heap size
;***
;fmsize.asm - far heap size
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _fmsize() - far heap memory block size
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
.list


sBegin	code
assumes	ds,data
assumes	cs,code

page
;***
;unsigned _fmsize(address) - return far heap memory block size
;
;Purpose:
;	Returns the size in bytes of a memory block in the far heap
;	allocated by _fmalloc().
;
;Entry:
;	far *address - ptr to memory block
;
;Exit:
;	returns size in bytes (unsigned)
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_fmsize,<PUBLIC>,<>

	parmD	address

cBegin

	les	bx,address
	mov	ax,es:[bx-2]
	and	al,not 1	; make even

cEnd	<nolocals>

sEnd	code

	end
