	page	,132
	title	frealloc - Reallocate a far heap block to a new size

;***
;frealloc.asm - Reallocate a block in the far heap to a new size.
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _frealloc() - reallocate a block in the far heap to a
;	new size.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _fheap

sEnd	data

externP  _fmalloc
externP  _ffree

externNP _resize
externNP _findseg

sBegin	code
	assumes cs,code
	assumes ds,data

;***
;void far *_frealloc(void far *fheapblk, size_t newsize)
;
;Purpose:
;	Change the size of the specified block in the far heap. First try
;	to resize the block in place (i.e., expand/contract it to newsize).
;	If this fails, try to allocate a new block of size newsize, copy
;	over the contents of the old block and free the old block.
;
;Entry:
;	void far *fheapblk  - pointer to block in the far heap + 2 (i.e.,
;			      pointer to the allocation area of a block)
;	size_t newsize	    - desired new size of the block
;
;Exit:
;	returns pointer to the new, or newly resized, block if successful
;	returns NULL if not successful, in the case the original block is
;	not altered
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

cProc	_frealloc,<PUBLIC>,<si,di,ds>


	parmD	fheapblk
	parmW	newsize

cBegin
	mov	dx,word ptr [fheapblk]
	mov	si,dx
	mov	ax,word ptr [fheapblk+2]
	mov	cx,[newsize]

; fheapblk == NULL is a special case: to conform with ANSI, the semantics are
; identical to _fmalloc(newsize).

	or	dx,ax			; NULL pointer?
	jz	do_fmalloc		;   yes, go allocate a new block

; fheapblk != NULL, newsize == 0 is another special case: to conform with
; ANSI, the semantics are to _ffree the block and return NULL.

	jcxz	do_ffree		;   newsize is 0, go free the block

; Fetch the heap segment descriptor for the segment containing the block

	mov	di,ds			; stash DGROUP in di for a while
	mov	bx,dataOFFSET _fheap
	push	cx			; save [newsize] value across call
	call	_findseg		; returns ds:bx pointing to descriptor
	pop	cx
	assumes ds,nothing

;	*** SHOULD WE JUMP TO A ROUTINE THAT SETS ERRNO TO E_?????? BEFORE
;	*** RETURNING NULL?

	jc	ret_null		; return NULL to caller

; First try resizing the original block. Note that if newsize <= original size
; of the block, this always works.

	push	[si-2]			; save original header on stack
	push	cx
	call	_resize
	pop	cx
	jc	try_fmalloc		; failed, go try to get a new block
	mov	ax,si
	mov	dx,ds			; return dx:ax = fheapblk
	and	byte ptr [si-2],not 1	; make sure block is marked inuse
	pop	cx			; clean up stack
	jmp	short done

; try_fmalloc
; Try to allocate a new block of the specified size. If successful, copy the
; contents of the old block to the new block and free the old block.

try_fmalloc:
	push	ds			; save pointer to original heap...
	push	bx			; ...segment descriptor
	mov	ds,di			; restore ds to DGROUP
	push	cx

	callcrt _fmalloc

	pop	cx			; clean up stack
	pop	bx			; restore pointer to original heap...
	pop	ds			; ...segment descriptor
	pop	cx			; retrieve original header
	and	cl,not 1		; cx = size of original block
	push	di			; save DGROUP
	mov	di,ax
	or	ax,dx			; was _fmalloc successful?
	pop	ax			; (stash DGROUP in ax)
	jz	failure 		;   no, go clean up and fail
	mov	es,dx			; es:di = pointer to new block + 2
	cld
	push	es			; save far pointer to new block + 2
	push	di
	push	ds			; save far pointer to original block
	push	si			; + 2
	shr	cx,1
	rep	movsw			; move (original block size)/2 words
	mov	ds,ax			; restore ds to DGROUP again

	callcrt _ffree	       ; free the original block

	add	sp,4			; clean off arg to _ffree
	pop	ax			; dx:ax = pointer to new block + 2
	pop	dx
	jmp	short done

; Special case handling mandated by ANSI.

do_fmalloc:
	push	cx

	callcrt _fmalloc

	pop	cx			; clean up stack
	jmp	short done

; Special case handling mandated by ANSI.

do_ffree:
	push	ax
	push	si

	callcrt _ffree

	add	sp,4			; clean up stack
	jmp	short ret_null

; failure
; Resizing and allocating have both failed. Restore the block to its original
; size and return NULL.

failure:
	call	_resize 		; restore original block size

ret_null:
	xor	ax,ax
	cwd

done:
cEnd	<nolocals>

sEnd	code
	end
