	page	,132
	title	 freelist - Free up all memory in a heap list
;***
;freelist.asm - Free up all memory in a heap list
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Free all memory in a heap list back to the OS.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include heap.inc
.list

ifdef _WINDOWS
ifdef _BAT16
	externP	BatFreeSeg		; BAT16 free global memory
else
	extrn	GLOBALFREE:far		; WIN free global memory
endif	; _BAT16
	extrn	GLOBALUNLOCK:far	; WIN unlock global memory
else
	%out *** ERROR: Currently supports _WINDOWS only.
	.err
endif


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
; _freelist -  Free up all memory in a heap list
;
;Purpose:
;	Free all memory in a heap list back to the OS.
;
;	Currently, this routine is used to free all heap segments back
;	to WINDOWS when a WIN DLL terminates.  This is necessary because
;	the segments are DDE_SHARE and, thus, WIN won't get them unless
;	they're explicitly released.
;
;Entry:
;	es:bx = linked heap list
;
;Exit:
;	void
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_freelist,<PUBLIC,NEAR>,<di>

cBegin	<nolocals>

;
; Walk the segment list freeing up each one.
; [Remember to get the next segment before we free up the current one.]
;

	les	bx,es:[bx].startseg	; get first segment
	; fall thru

free_next:
	mov	cx,es			; segment selector zero ??
	jcxz	done			; if so, we're done

	; free up this segment

ifdef _WINDOWS
	mov	ax,es:[bx].handle	; ax = windows handle
	les	bx,es:[bx].nextseg	; es:bx = next entry

	push	bx			; save next entry around free
	push	es

	push	ax			; once for GLOBALUNLOCK
	push	ax			; once for GLOBALFREE
	call	GLOBALUNLOCK		; unlock the segment
ifdef _BAT16
	call	BatFreeSeg
else
	call	GLOBALFREE		; free segment
endif
	pop	es			; restore pointer
	pop	bx
	jmp	short free_next 	; loop again
endif

done:

cEnd

sEnd	code

	end
